package com.elitesland.fin.provider.flow;


import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.account.AccountIocService;
import com.elitesland.fin.application.service.account.AccountRuleConfigService;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.flow.AccountFlowRpcDTO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + AccountFlowRpcService.PATH)
@Slf4j
public class AccountFlowRpcServiceImpl implements AccountFlowRpcService {

    public final AccountFlowService accountFlowService;

    public final AccountRuleConfigService accountRuleConfigService;

    private final AccountIocService accountIocService;

    private final AccountService accountService;

    private final SeqNumProvider seqNumProvider;

    private final TaskExecutor taskExecutor;

    private final FinSalMqProcessor finSalMqProcessor;

    private final TransactionTemplate transactionTemplate;




    @Override
    public ApiResult<AccountFlowRpcDTO> save(List<AccountFlowRpcParam> rpcParams) {
        log.info("财务流水保存rpc接口，参数：{}", JSON.toJSONString(rpcParams));
        if (CollectionUtils.isEmpty(rpcParams)) {
            return ApiResult.fail("数据为空");
        }
        List<AccountFlowParam> accountFlowParamList = rpcParams.stream().map(
                AccountFlowConvert.INSTANCE::rpcParamToParam).collect(Collectors.toList());

        //校验逻辑和业务处理逻辑侧重点放在RPC层还是正常的Service层
        //考虑到糅合度太高,若对外提供或内部逻辑一方发生变化有差异时

        //校验可以拆分细一点，组合使用，提示具体清晰哪个值为空

        AccountFlowVO accountFlowVO = accountFlowService.save(accountFlowParamList);

        return ApiResult.ok();
    }

    @Override
    public ApiResult<Boolean> checkAccountBalance(AccountFlowRpcParam accountFlowRpcParam) {
        log.info("财务校验账户余额rpc接口，参数：{}", JSON.toJSONString(accountFlowRpcParam));
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.accountFlowRpcParam2AccountFlowParam(accountFlowRpcParam);
        return ApiResult.ok(accountFlowService.checkAccountBalance(accountFlowParam));
    }

    @Override
    public ApiResult<Boolean> generateAccountFlow(AccountFlowRpcParam accountFlowRpcParam) {
        log.info("生成信用账户流水rpc接口，接收到参数{}", JSONUtil.toJsonStr(accountFlowRpcParam));
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.accountFlowRpcParam2AccountFlowParam(accountFlowRpcParam);
        accountFlowService.generateAccountFlow(accountFlowParam);
        return ApiResult.ok();
    }



}
