package com.elitesland.fin.application.convert.creditaccount;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.excel.creditaccount.CreditAccountImportEntity;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSaveParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountDetailVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountSnapshotVo;
import com.elitesland.fin.application.service.excel.entity.CreditAccountExportEntity;
import com.elitesland.fin.application.service.excel.entity.CreditAccountSnapshotExportEntity;
import com.elitesland.fin.dto.creditaccount.CreditAccountRpcDTO;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountSnapshotDO;
import com.elitesland.fin.param.creditaccount.CreditAccountRpcParam;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.convert.account
 * @date 2023/2/16 15:15
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface CreditAccountConvert {
    CreditAccountConvert INSTANCE = Mappers.getMapper(CreditAccountConvert.class);

    CreditAccountParam pageParam2QueryParam(CreditAccountPageParam pageParam);

    CreditAccountDO saveParam2DO(CreditAccountSaveParam param);

    CreditAccountDetailVO do2DetailVO(CreditAccountDO creditAccountDO);

    List<CreditAccountDO> importEntitys2Dos(List<CreditAccountImportEntity> saveList);

    List<CreditAccountSaveParam> rpcParam2Param(List<CreditAccountRpcParam> param);

    PagingVO<CreditAccountSnapshotExportEntity> pageVo2Entity(PagingVO<CreditAccountSnapshotVo> pagingVO);

    List<CreditAccountSnapshotDO> creditDos2Snapshots(List<CreditAccountDO> accountDOList);

    CreditAccountParam rpc2Param(CreditAccountRpcParam param);

    List<CreditAccountRpcDTO> dtos2RpcDtos(List<CreditAccountDTO> creditAccountDTOS);

    PagingVO<CreditAccountExportEntity> pageVo2ExportEntity(PagingVO<CreditAccountPageVO> pagingVO);

    CreditAccountDO ConvertDTO2DO(CreditAccountDTO creditAccountDTO);

    CreditAccountSaveParam rpcParam2Param(CreditAccountRpcParam param);
}
