package com.elitesland.fin.application.service.arorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderExPageParam;
import com.elitesland.fin.application.facade.param.arorder.FinArOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023-09-05 13:09
 */
public interface ArOrderExService {

    /**
     * 应收单分页查询.
     *
     * @param arOrderExPageParam 查询条件
     * @return 分页结果集
     */
    PagingVO<ArOrderExVo> page(ArOrderExPageParam arOrderExPageParam);

    ArOrderExVo getDetailExInfo(ArOrderVO res);

    /**
     * 查询明细集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    List<ArOrderDtlExVo> listArOrderDetail(FinArOrderDetailQuery query);

    /**
     * 更新核销金额.
     *
     * @param arDId 明细ID
     * @param amt   金额
     * @param verType   核销类型
     */
    void updateVerAmt(Long arDId, BigDecimal amt,String verType);

    /**
     * 更新核销中金额.
     *
     * @param arDId 明细ID
     * @param amt   金额
     */
    void updateMiddleVerAmt(Long arDId, BigDecimal amt);

    /**
     * 通过应收单id查询明细信息
     *
     * @param id
     * @return
     */
    ApiResult<ArOrderExVo> info(Long id);

    /**
     * 应收单明细分页查询.
     *
     * @param arOrderDtlExPageParam 查询条件
     * @return 分页结果集
     */
    PagingVO<ArOrderDtlExVo> detailPage(ArOrderDtlExPageParam arOrderDtlExPageParam);
}
