package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApHeadDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApHeadRepo;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApHeadRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyApHeadServiceImpl implements FinApPayVerApplyApHeadService {

    private final FinApPayVerApplyApHeadRepo finApPayVerApplyApHeadRepo;

    private final FinApPayVerApplyApHeadRepoProc finApPayVerApplyApHeadRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;
    private final ApOrderRepoProc apOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public Long create(Long masId, FinApPayVerApplyApHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinApPayVerApplyApHeadDO entity = FinApPayVerApplyApHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);

        if (StringUtils.isBlank(entity.getInOutCust()) || StringUtils.isBlank(entity.getRelevanceOuCode())){
            List<ApOrderDTO> apOrderDTOList = apOrderRepoProc.selectInOutCustByApOrderNo(Collections.singletonList(entity.getApOrderNo()));
            Map<String, ApOrderDTO> apOrderMap = CollectionUtil.isEmpty(apOrderDTOList) ? new HashMap<>() : apOrderDTOList.stream().collect(Collectors.toMap(ApOrderDTO::getApOrderNo, t -> t, (t1, t2) -> t1));
            ApOrderDTO apOrderDTO = apOrderMap.get(entity.getApOrderNo());
            if (Objects.nonNull(apOrderDTO)){
                String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? apOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? apOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
        }


        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.FIN_AP_PAY_VER_APPLY_AP_HEAD, entity);
        return finApPayVerApplyApHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyApHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinApPayVerApplyApHeadVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyApHeadVO> finApPayVerApplyApHeadVOList = finApPayVerApplyApHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyApHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finApPayVerApplyApHeadVOList)){
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finApPayVerApplyApHeadVOList.stream().map(FinApPayVerApplyApHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyApHeadVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finApPayVerApplyApHeadVOList;
    }

	@Override
	@SysCodeProc
	public List<FinApPayVerApplyApHeadVO> listByIds(FinApPayVerApplyQuery query,Collection<Long> ids) {
		return finApPayVerApplyApHeadRepoProc.listByIds(query,ids)
				.stream()
				.map(FinApPayVerApplyApHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
