/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceApplyParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceApplyRequest;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceResultParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedPayload;
import com.elitesland.fin.infinity.aisino.vo.param.InvoiceRequestSerialNoParam;
import com.elitesland.fin.infinity.aisino.vo.param.ItemDetail;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AisinoPayloadService {
    private static final Logger log = LoggerFactory.getLogger(AisinoPayloadService.class);
    @Autowired
    private UdcProvider sysUdcService;
    @Value(value="${aisino.encrypt.key:Y#Y*B!PC}")
    private String encryptKey;
    @Value(value="${aisino.api.appid:YYBPC}")
    private String appId;
    @Value(value="${aisino.api.username:15316018535}")
    private String username;
    @Value(value="${aisino.api.url:http://221.234.42.184:9236}")
    public String baseUrl;

    public AisinoCoverParamPayload assembleAisinoPayload(String param, String taxNo) {
        log.info("assembleAisinoPayload: {}", (Object)param);
        return AisinoCoverParamPayload.builder().APPID(this.appId).USERNAME(this.username).NSRSBH(taxNo).DATA(this.encrypt(param)).build();
    }

    public AisinoBlueInvoiceApplyParam blueInvoiceApplyInitial(InvoiceApplySaveParam saveParam, SaleInvdDtlDO saleInvdDtlDO) {
        AisinoBlueInvoiceApplyParam row = new AisinoBlueInvoiceApplyParam();
        if (saleInvdDtlDO != null) {
            row.setFPQQLSH(saleInvdDtlDO.getFlowNo());
        } else {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String randomStr = timestamp.substring(timestamp.length() - 5);
            String randomFiveDigits = String.format("%05d", (int)(Math.random() * 100000.0));
            row.setFPQQLSH(saveParam.getSaleTaxNo() + randomStr + randomFiveDigits);
        }
        AisinoBlueInvoiceApplyRequest request = new AisinoBlueInvoiceApplyRequest();
        request.setDJH(saveParam.getApplyNo());
        request.setGMFMC(saveParam.getInvCustCode());
        request.setGMFSH(saveParam.getCustTaxNo());
        request.setGMFYH(saveParam.getInvBankNo());
        request.setGMFYHZH(saveParam.getBankAccount());
        request.setGMFRYXZ("1");
        request.setKPLX("0");
        if (saveParam.getInvType().equals("81")) {
            request.setFPZLDM("01");
        } else if (saveParam.getInvType().equals("82")) {
            request.setFPZLDM("02");
        }
        request.setJSHJ(this.scale(saveParam.getTotalAmt()));
        if (!Objects.equals(request.getGMFRYXZ(), "1")) {
            request.setBZ("\u8d2d\u4e70\u65b9\u5730\u5740\uff1a" + saveParam.getCustAdd() + ";\u7535\u8bdd\uff1a" + saveParam.getPhone() + ";\u8d2d\u65b9\u5f00\u6237\u94f6\u884c\uff1a" + saveParam.getCustBank() + ";\u94f6\u884c\u8d26\u53f7\uff1a" + saveParam.getCustBankAcc());
        }
        request.setXHFKHH(saveParam.getSaleBank());
        request.setXHFYHZH(saveParam.getSaleBankAcc());
        request.setGMFZRRBS("N");
        request.setSFZSGMFYHZH("N");
        request.setSFZSXSFYHZH("N");
        request.setSFZSGMFDZDH("N");
        request.setSFZSXSFDZDH("N");
        BigDecimal netAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        Map taxTypeUdc = this.sysUdcService.getValueMapByUdcCode("yst-supp", "TAX_CLASS_CODE");
        ArrayList<ItemDetail> itemDetails = new ArrayList<ItemDetail>();
        int lineNo = 1;
        for (InvoiceDetailSaveParam detail : saveParam.getDetails()) {
            netAmt = netAmt.add(detail.getExclTaxAmt());
            taxAmt = taxAmt.add(detail.getTaxAmt());
            ItemDetail drow = new ItemDetail();
            drow.setXH(Integer.toString(lineNo));
            drow.setSPBM(detail.getTaxCode().length() < 19 ? detail.getTaxCode().concat(StringUtils.repeat((String)"0", (int)(19 - detail.getTaxCode().length()))) : detail.getTaxCode());
            drow.setSPMC(detail.getItemName());
            String taxTypeName = (String)taxTypeUdc.get(detail.getTaxCode());
            if (taxTypeName != null) {
                drow.setSPJM("*" + taxTypeName + "*");
            }
            drow.setGGXH(detail.getItemType());
            drow.setJLDW(detail.getUom());
            drow.setSLV(detail.getTaxRate().setScale(2, RoundingMode.HALF_UP).toString());
            drow.setSL(Objects.isNull(detail.getQty()) ? null : detail.getQty().toString());
            drow.setDJ(this.scale(detail.getPrice()));
            drow.setJE(this.scale(detail.getTotalAmt()));
            drow.setSE(this.scale(detail.getTaxAmt()));
            drow.setKCE("0");
            if (detail.getDiscountAmt() != null && detail.getDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
                drow.setHXZ("2");
            } else {
                drow.setHXZ("0");
            }
            drow.setHSBZ("1");
            itemDetails.add(drow);
            ++lineNo;
            if (detail.getDiscountAmt() == null || detail.getDiscountAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            ItemDetail discountRow = new ItemDetail();
            discountRow.setXH(Integer.toString(lineNo));
            discountRow.setSPBM(detail.getTaxCode().length() < 19 ? detail.getTaxCode().concat(StringUtils.repeat((String)"0", (int)(19 - detail.getTaxCode().length()))) : detail.getTaxCode());
            discountRow.setSPMC(detail.getItemName());
            if (taxTypeName != null) {
                discountRow.setSPJM("*" + taxTypeName + "*");
            }
            discountRow.setGGXH("");
            discountRow.setJLDW("");
            discountRow.setSLV(detail.getTaxRate().setScale(2, RoundingMode.HALF_UP).toString());
            discountRow.setSL("");
            discountRow.setDJ("");
            discountRow.setJE(this.scale(detail.getTotalAmt().negate()));
            discountRow.setSE(this.scale(detail.getTaxAmt().negate()));
            discountRow.setKCE("");
            discountRow.setHXZ("1");
            itemDetails.add(discountRow);
            ++lineNo;
        }
        request.setHJJE(this.scale(netAmt));
        request.setHJSE(this.scale(taxAmt));
        request.setMXLIST(itemDetails);
        row.setREQUEST(request);
        return row;
    }

    public InvoiceRequestSerialNoParam getInvoiceInfoByFlowNo(SaleInvdDtlDO saleInvdDtlDO) {
        InvoiceRequestSerialNoParam param = new InvoiceRequestSerialNoParam();
        param.setFPQQLSH(saleInvdDtlDO.getFlowNo());
        return param;
    }

    public String convertRedInitial(InvoiceRedApplySaveParam saveParam) {
        AisinoRedPayload row = new AisinoRedPayload();
        row.setLZFPQDHM(saveParam.getOriginApplyNo());
        row.setGMFNSRSBH(saveParam.getCustTaxNo());
        row.setXSFNSRSBH(saveParam.getSaleTaxNo());
        row.setLZKPRQ(saveParam.getInvDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        row.setKPFNSRSBH(saveParam.getSaleTaxNo());
        row.setGJBQ("1");
        row.setTDYSLXDM("");
        if (saveParam.getInvType().equals("VANA")) {
            row.setFPLXDM("81");
        } else if (saveParam.getInvType().equals("VANSP")) {
            row.setFPLXDM("82");
        }
        row.setLZFPHM("");
        row.setLZFPDM("");
        row.setFPLYDM("2");
        return JSON.toJSONString((Object)row);
    }

    public String convertRedSave(InvoiceRedInitialRespVO saveParam) {
        AisinoRedPayload row = new AisinoRedPayload();
        return JSON.toJSONString((Object)row);
    }

    public String convertRedOpen(AisinoRedInvoiceParam saveParam) {
        AisinoRedPayload row = new AisinoRedPayload();
        return JSON.toJSONString((Object)row);
    }

    public String getBlueResult(String applyNo, LocalDateTime applyTime) {
        AisinoBlueInvoiceResultParam result = new AisinoBlueInvoiceResultParam();
        result.setFPHM(applyNo);
        result.setKPRQ(applyTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        return JSON.toJSONString((Object)result);
    }

    public String encrypt(String row) {
        return this.getEncryptedData(JSONObject.toJSONString((Object)row));
    }

    private String getEncryptedData(String row) {
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), this.encryptKey);
        if (encryptedBytes == null) {
            log.error("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:{}", (Object)row);
            throw new BusinessException("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    public <T> T decrypt(String row, Class<T> clazz) {
        log.info("\u89e3\u5bc6\u5165\u53c2:{},\u7c7b\u540d:{}", (Object)row, clazz);
        String encryptedData = this.getDecryptedData(row);
        log.info("\u89e3\u5bc6\u6570\u636e:{}", (Object)encryptedData);
        return (T)JSON.parseObject((String)encryptedData, clazz);
    }

    private String getDecryptedData(String encryptedData) {
        byte[] encryptedBytes = InvoiceIssueUtil.parseHexStr2Byte(encryptedData);
        if (encryptedBytes == null) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25,\u52a0\u5bc6\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u52a0\u5bc6\u6570\u636e:" + encryptedData);
        }
        try {
            byte[] decryptedBytes = InvoiceIssueUtil.decrypt(encryptedBytes, this.encryptKey);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25,\u89e3\u5bc6\u8fc7\u7a0b\u5f02\u5e38\uff0c\u52a0\u5bc6\u6570\u636e:" + encryptedData, e);
        }
    }

    private String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }
}

