package com.elitesland.fin.application.service.invoice;


import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;

import java.util.List;

/**
 * @author zhiMing
 */
public interface InvoiceService {

    /**
     * 根据业务单据 - 提交开票申请
     *
     * @param param 开票参数
     * @return 开票申请ID
     */
    long create(InvoiceApplyParam param);

    /**
     * 根据业务单据 - 重新开票
     *
     * @param applyNo 原开票申请单号
     * @return 开票申请ID
     */
    Long redraft(String applyNo);

//    /**
//     * 根据加盟商code查询发票抬头
//     * @return
//     */
//    List<InvoiceRpcDTO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam);
//
//    /**
//     * 开票页列表
//     *
//     * @param param
//     * @return
//     */
//    PagingVO<SaleInvoiceVO> page(SaleInvPageParam param);

    void rePush(List<Long> idList);

    void rePush2(ApplyRePushParam param);

    void getBlueResult(List<Long> saleInvIdList);


    /**
     * 获取指定主数据ID的开票明细列表。
     *
     * @param masId 主数据ID，用于查询相关的销售明细信息。
     * @return 返回一个SaleInvDtlVO对象的列表，包含了指定主数据ID的所有销售明细。
     */
    List<SaleInvDtlVO> getDtlList(Long masId);
}
