package com.elitesland.fin.domain.service.creditaccount;


import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountIocConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.entity.creditaccount.CreditAccountIoc;
import com.elitesland.fin.entity.creditaccount.CreditAccountIocDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountIocRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountIocRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Service
@AllArgsConstructor
public class CreditAccountIocDomainServiceImpl implements CreditAccountIocDomainService {

    private final CreditAccountIocRepo creditAccountIocRepo;
    private final CreditAccountIocRepoProc CreditAccountIocRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountIocDTO> search(CreditAccountIocParamVO param) {
        val pagingVo = CreditAccountIocRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveAccountIoc(CreditAccountIoc accountIoc, Optional<CreditAccountIocDTO> optional) {
        if (optional.isPresent()) {
            CreditAccountIocDTO accountIocDTO = optional.get();
            //修改时，不可编辑
            accountIoc.setIoCode(accountIocDTO.getIoCode());
            //修改
            accountIoc.setId(accountIocDTO.getId());
            accountIoc.setCreator(accountIocDTO.getCreator());
            accountIoc.setCreateUserId(accountIocDTO.getCreateUserId());
            accountIoc.setCreateTime(accountIocDTO.getCreateTime());
            accountIoc.setModifyTime(LocalDateTime.now());

        } else {
            accountIoc.setId(null);
            accountIoc.setCreator(null);
            accountIoc.setCreateUserId(null);
            accountIoc.setCreateTime(LocalDateTime.now());
            accountIoc.setModifyUserId(null);
            accountIoc.setUpdater(null);
            accountIoc.setModifyTime(LocalDateTime.now());
        }

        CreditAccountIocDO accountIocDO = CreditAccountIocConvert.INSTANCE.enToDo(accountIoc);
        Long id = creditAccountIocRepo.save(accountIocDO).getId();

        return id;
    }

    /**
     * 根据ID查询账户事务码信息
     *
     * @param id 账户事务码ID
     * @return 账户事务码对象
     */
    @Override
    @SysCodeProc
    public Optional<CreditAccountIocDTO> findById(Long id) {
        return creditAccountIocRepo.findById(id).map(CreditAccountIocConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<CreditAccountIocDTO> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Optional.empty();
        }
        CreditAccountIocParamVO param = new CreditAccountIocParamVO();
        param.setIoCode(code);
        JPAQuery<CreditAccountIocDTO> jpaQuery = CreditAccountIocRepoProc.select(param);

        return Optional.of(jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<CreditAccountIocDTO> whAreaSettingDTOList = creditAccountIocRepo.findAllById(idList).stream().map(CreditAccountIocConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }

        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocDTO> findByCodeBatch(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.EMPTY_LIST;
        }
        CreditAccountIocParamVO param = new CreditAccountIocParamVO();
        param.setIoCodeList(codeList);
        JPAQuery<CreditAccountIocDTO> jpaQuery = CreditAccountIocRepoProc.select(param);
        List<CreditAccountIocDTO> accountIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty(accountIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return accountIocDTOS;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocDTO> selectByParam(CreditAccountIocParamVO param) {
        JPAQuery<CreditAccountIocDTO> jpaQuery = CreditAccountIocRepoProc.select(param);
        List<CreditAccountIocDTO> accountIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty(accountIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return accountIocDTOS;
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        CreditAccountIocRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

    @Override
    public List<CreditAccountIocDTO> queryByAccountIocParam(CreditAccountIocParam accountIocParam) {
        return CreditAccountIocRepoProc.queryByAccountIocParam(accountIocParam);
    }



}
