package com.elitesland.fin.application.web.inputinv;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.fin.application.facade.param.inputInv.InputInvSaveParam;
import com.elitesland.fin.application.facade.vo.inputinv.InputInvDtlVO;
import com.elitesland.fin.application.facade.vo.inputinv.InputInvVO;
import com.elitesland.fin.application.service.inputinv.InputInvDtlService;
import com.elitesland.fin.application.service.inputinv.InputInvService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.inputinv.InputInvDO;
import com.elitesland.fin.domain.param.inputinv.InputInvDtlPageParam;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/5/6 13:22
 */
@RestController
@RequestMapping("/fin/inputInv")
@RequiredArgsConstructor
@Api(value = "进项发票", tags = {"进项发票"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_INPUT_INV, businessDoClass = InputInvDO.class)
public class InputInvController {

    private final InputInvService inputInvService;

    private final InputInvDtlService inputInvDtlService;

    @PostMapping("page")
    @ApiOperation("分页查询进项发票")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "进项发票分页",
            businessObjectType = FinBusinessObjectConstant.FIN_INPUT_INV,operationCode = FinBusinessObjectConstant.FIN_INPUT_INV_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<InputInvVO>> page(@RequestBody InputInvPageParam param) {
        return ApiResult.ok(inputInvService.page(param));
    }

    @PostMapping("pageDtl")
    @ApiOperation("分页查询进项发票明细")
    public ApiResult<PagingVO<InputInvDtlVO>> pageDtl(@RequestBody InputInvDtlPageParam param) {
        return ApiResult.ok(inputInvDtlService.page(param));
    }


    @DeleteMapping("delete")
    @ApiOperation("删除进项发票")
    public ApiResult<List<Long>> delete(@RequestBody List<Long> ids) {
        return ApiResult.ok(inputInvService.deleteByIds(ids));
    }

    @GetMapping("/query/{id}")
    @ApiOperation("查询发票详细信息(无明细信息)")
    public ApiResult<InputInvVO> queryById(@PathVariable("id") Long id) {
        return ApiResult.ok(inputInvService.queryById(id));
    }


    @GetMapping("/queryDetails/{id}")
    @ApiOperation("查询发票详细信息(明细集合)")
    public ApiResult<InputInvVO> queryDetails(@PathVariable("id") Long id) {
        return ApiResult.ok(inputInvService.queryDetailsById(id));
    }

    @PostMapping("save")
    @ApiOperation("新增/修改-保存进项发票")
    public ApiResult<Long> save(@RequestBody InputInvSaveParam param) {
        return inputInvService.save(param);
    }

    @PostMapping("submit")
    @ApiOperation("新增/修改-提交进项发票")
    public ApiResult<Long> submit(@RequestBody InputInvSaveParam param) {
        return inputInvService.submit(param);
    }

}
