package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_acc_eng_det_data_line")
@org.hibernate.annotations.Table(appliesTo = "fin_acc_eng_det_data_line", comment = "会计引擎数据行详情明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccEngDetDataLineDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "serial_num", columnDefinition = "int(6) comment '序列号'")
    private Integer serialNum;

    @Column(name = "column_name", columnDefinition = "varchar(32) comment '字段名称'")
    private String columnName;

    @Column(name = "column_type", columnDefinition = "varchar(32) comment '字段类型'")
    private String columnType;

    @Column(name = "column_length", columnDefinition = "int(6) comment '字段长度'")
    private Integer columnLength;

    @Column(name = "column_comment", columnDefinition = "varchar(64) comment '字段含义'")
    private String columnComment;

    @Column(name = "source_type", columnDefinition = "varchar(20) comment '来源类型'")
    private String sourceType;

    @Column(name = "constant", columnDefinition = "varchar(32) comment '常数'")
    private String constant;

    @Column(name = "column_source", columnDefinition = "varchar(32) comment '列来源'")
    private String columnSource;

    @Column(name = "output_column", columnDefinition = "varchar(20) comment '输出字段'")
    private String outputColumn;

    @Column(name = "flexible_code", columnDefinition = "varchar(20) comment '值集编码'")
    private String flexibleCode;

    @Column(name = "fast_code", columnDefinition = "varchar(20) comment '快码编码'")
    private String fastCode;
}
