package com.elitesland.fin.application.facade.vo.recorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023-09-05 22:20
 */
@Data
public class RecOrderExVo extends RecOrderVO implements Serializable {

    @ApiModelProperty("收款单主表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '收款单主表关联id'")
    private Long relateId;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("红冲标志")
    @Column(name = "red_flush_sign", columnDefinition = "tinyint(1)  comment '红冲标志'")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    @Column(name = "third_payment_assistance", columnDefinition = "varchar(32)  comment '第三方支付辅助'")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    @Column(name = "consumer_card_ssistance", columnDefinition = "varchar(32)  comment '消费卡辅助'")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    @Column(name = "credit_card_assistance", columnDefinition = "varchar(32)  comment '信用卡辅助'")
    private String creditCardAssistance;

    @ApiModelProperty("结算方式")
    @Column(name = "pay_type", columnDefinition = "varchar(32)  comment '结算方式'")
    private String payType;

    @ApiModelProperty("收款银行账户")
    @Column(name = "rec_bank", columnDefinition = "varchar(32)  comment '收款银行账户'")
    private String recBank;

    @ApiModelProperty("付款银行账户")
    @Column(name = "pay_bank", columnDefinition = "varchar(32)  comment '付款银行账户'")
    private String payBank;

    @ApiModelProperty("收款单明细扩展数据")
    private List<RecOrderDtlExVo> items;

    @ApiModelProperty("客户名称")
    private String customName;

    @ApiModelProperty("业务员名称")
    private String businessName;

    @ApiModelProperty("申请核销中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("扩展表ID")
    private Long extId;


}
