package com.elitesland.fin.application.facade.vo.inputinv;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/5/6 17:07
 */
@Data
public class InputInvDtlVO implements Serializable {
    private static final long serialVersionUID = -2710706132973467598L;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("发票代码")
    private String invCode;

    @ApiModelProperty("原蓝票号")
    private String blueInvNo;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("规格型号")
    private String itemType;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("发票类型")
    @SysCode(sys = "yst-fin", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty("红/蓝票")
    @SysCode(sys = "yst-fin",mod = "OPEN_TYPE")
    private String invKind;
    private String invKindName;

    @ApiModelProperty("开票状态")
    @SysCode(sys = "yst-fin",mod = "INV_STATE")
    private String invState;
    private String invStateName;

    @ApiModelProperty("查验状态")
    @SysCode(sys = "yst-fin",mod = "EXAM_TYPE")
    private String examType;
    private String examTypeName;

    @ApiModelProperty("备注")
    private String remark;
}
