package com.elitesland.fin.domain.entity.arorder;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/27
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name="ar_order_record")
@org.hibernate.annotations.Table(appliesTo = "ar_order_record", comment = "应收单记录表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ArOrderRecordDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 7572461181006816864L;

   /* @Column(name = "source_doc", columnDefinition = "varchar(32) comment '来源单据'")
    private String sourceDoc;*/

    @Column(name = "source_doc_type", columnDefinition = "varchar(32) comment '来源单据类型'")
    private String sourceDocType;

    @Column(name = "source_doc_status", columnDefinition = "varchar(32) comment '来源单据状态'")
    private String sourceDocStatus;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "create_mode", columnDefinition = "varchar(32) comment '单据来源'")
    private String createMode;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "bu_date", columnDefinition = "datetime(6) comment '业务日期'")
    private LocalDateTime buDate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(32) comment '币种'")
    private String currName;

    @Column(name = "local_curr_code", columnDefinition = "varchar(32) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(32) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户名称'")
    private String custName;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '部门ID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '部门编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '部门名称'")
    private String buName;

    @Column(name = "pay_ment_name", columnDefinition = "varchar(32) comment '付款条件'")
    private String payMentName;

    @Column(name = "pay_ment_id", columnDefinition = "varchar(20) comment '付款条件id'")
    private String payMentId;

    @Column(name = "pay_ment_code", columnDefinition = "varchar(32) comment '付款条件code'")
    private String payMentCode;

    @Column(name = "sale_user_id", columnDefinition = "bigint(20) comment '销售业务员ID'")
    private Long saleUserId;

    @Column(name = "sale_user_code", columnDefinition = "varchar(32) comment '销售业务员code'")
    private String saleUserCode;

    @Column(name = "sale_user", columnDefinition = "varchar(32) comment '销售业务员'")
    private String saleUser;

    @Column(name = "doc_type2", columnDefinition = "varchar(32) comment 'B端订单/C端订单'")
    private String docType2;

    @Column(name = "es1", columnDefinition = "varchar(32) comment '订单客户'")
    private String es1;

    @Column(name = "es2", columnDefinition = "varchar(32) comment '发票号'")
    private String es2;

    @Column(name = "es3", columnDefinition = "datetime(6) comment '开票日期'")
    private LocalDateTime es3;

    @Column(name = "es4", columnDefinition = "varchar(32) comment '发票类型'")
    private String es4;

    @Column(name = "es5", columnDefinition = "datetime(6) comment '起算日期'")
    private LocalDateTime es5;

    @Column(name = "es6", columnDefinition = "varchar(32) comment '红冲标志'")
    private String es6;

    @Column(name = "ar_flag", columnDefinition = "varchar(32) comment '是否生成应收单标记(0未生成,1已生成,2生成失败)'")
    private String arFlag;

    @Column(name = "fail_msg", columnDefinition = "varchar(512) comment '失败原因'")
    private String failMsg;

    @Column(name = "protocol_code", columnDefinition = "varchar(100) comment '协议编码'")
    private String protocolCode;

    /*@Column(name = "bu_type", columnDefinition = "varchar(32) comment '业务类型'")
    private String buType;

    @Column(name = "ver_state", columnDefinition = "varchar(32) comment '核销状态'")
    private String verState;

    @Column(name = "ver_amt", columnDefinition = "decimal(18,8) comment '已核销金额'")
    private BigDecimal verAmt;

    // 组织
    @Column(name = "org_id", columnDefinition = "bigint(20) comment '组织ID'")
    private Long orgId;

    @Column(name = "org_code", columnDefinition = "varchar(32) comment '组织编码'")
    private String orgCode;

    @Column(name = "org_name", columnDefinition = "varchar(32) comment '组织名称'")
    private String orgName;*/

    /*@Column(name = "ar_order_type", columnDefinition = "varchar(32) comment '单据类型'")
    private String arOrderType;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(64) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(32) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;*/

   /* @ApiModelProperty("扩展表关联字段")
    @Column(name = "relate_id", columnDefinition = "bigint(20) comment '扩展表关联id'")
    private Long relateId;

    @Column(name = "es7", columnDefinition = "varchar(32) comment '开票备注'")
    private String es7;

    @Column(name = "es8", columnDefinition = "varchar(32) comment '第三方支付辅助'")
    private String es8;

    @Column(name = "es9", columnDefinition = "varchar(32) comment '消费卡辅助'")
    private String es9;

    @Column(name = "es10", columnDefinition = "varchar(32) comment '信用卡辅助'")
    private String es10;

    @Column(name = "settlement_type", columnDefinition = "varchar(32) comment '结算方式'")
    private String settlementType;
    @Column(name = "proposed_status", columnDefinition = "varchar(100) comment '拟定状态，DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功'")
    private String proposedStatus;*/

    /*@Column(name = "ar_type_id", columnDefinition = "bigint(20) comment '应收单类型定义ID'")
    private Long arTypeId;

    @Column(name = "ar_type_name", columnDefinition = "varchar(32) comment '应收单类型名称'")
    private String arTypeName;

    @Column(name = "ar_type_code", columnDefinition = "varchar(32) comment '应收单类型代码'")
    private String arTypeCode;*/

   /* @Column(name = "ar_order_no", columnDefinition = "varchar(32) comment '应收单编号'")
    private String arOrderNo;

    @Column(name = "order_state", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;*/

    /*@Column(name = "doc_type", columnDefinition = "varchar(32) comment '具体订单场景'")
    private String docType;



    @Column(name = "doc_cls", columnDefinition = "varchar(32) comment '传SO代表正向，传RSO代表退货负向'")
    private String docCls;*/

   /* @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核日期'")
    private LocalDateTime auditDate;


    @Column(name = "oper_user_id", columnDefinition = "bigint(20) comment '经办人ID'")
    private Long operUserId;

    @Column(name = "operator", columnDefinition = "varchar(32) comment '经办人'")
    private String operator;

    @Column(name = "tax_flag", columnDefinition = "tinyint(1) comment '是否含税'")
    private Boolean taxFlag;

    @Column(name = "init_flag", columnDefinition = "tinyint(1) comment '是否期初'")
    private Boolean initFlag;

    @Column(name = "audit_rejection", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejection;*/
}
