/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.workflow;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedSaveRespVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoResultResp;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/INVOICE_REDRAFT/callBack"})
@Transactional
public class InvoiceRedraftCallbackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(InvoiceRedraftCallbackController.class);
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceApplyService invoiceApplyService;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final InvoiceSaveService invoiceSaveService;
    private final AisinoService aisinoService;
    private final SaleInvRepoProc saleInvRepoProc;
    private final AisinoPayloadService aisinoPayloadService;

    private InvoiceRedraftDO getInvRedraftDO(String businessKey) {
        Long masId = Long.valueOf(businessKey.split("#")[1].trim());
        Optional byId = this.invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new RuntimeException("\u91cd\u65b0\u5f00\u7968(id:" + masId + ")\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5ba1\u6279");
        }
        return (InvoiceRedraftDO)((Object)byId.get());
    }

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(new ArrayList());
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03:{}", (Object)payload.toString());
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    private static String getDecryptedData(String encryptedData) {
        String key = "12345678";
        byte[] encryptedBytes = InvoiceIssueUtil.parseHexStr2Byte(encryptedData);
        if (encryptedBytes == null) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25,\u52a0\u5bc6\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u52a0\u5bc6\u6570\u636e:" + encryptedData);
        }
        try {
            byte[] decryptedBytes = InvoiceIssueUtil.decrypt(encryptedBytes, key);
            return InvoiceIssueUtil.byteToHexString(decryptedBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25,\u89e3\u5bc6\u8fc7\u7a0b\u5f02\u5e38\uff0c\u52a0\u5bc6\u6570\u636e:" + encryptedData, e);
        }
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        InvoiceRedraftDO invoiceRedraftDO = this.getInvRedraftDO(payload.getBusinessKey());
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.workflowProcInstStatus, (Object)procInstStatus).where(new Predicate[]{this.qdo.id.eq((Object)invoiceRedraftDO.getId())});
        JPAUpdateClause saleInvdDtlDOJpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qSaleInvdDtlDO).where(new Predicate[]{this.qSaleInvdDtlDO.invNo.eq((Object)invoiceRedraftDO.getInvoiceNo())});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                jpaUpdateClause.setNull((Path)this.qdo.workflowProcInstId);
                jpaUpdateClause.setNull(this.qdo.workflowProcInstStatus);
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                jpaUpdateClause.set(this.qdo.workflowProcInstStatus, (Object)ProcInstStatus.REJECTED);
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
                jpaUpdateClause.set(this.qdo.workflowProcInstStatus, (Object)ProcInstStatus.APPROVING);
                saleInvdDtlDOJpaUpdateClause.set((Path)this.qSaleInvdDtlDO.invoiceRedraftState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.setNull((Path)this.qdo.workflowCurrentNodeName);
                jpaUpdateClause.setNull((Path)this.qdo.workflowCurrentNodeKey);
                jpaUpdateClause.setNull((Path)this.qdo.workflowCurrentUserIds);
                jpaUpdateClause.set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
                jpaUpdateClause.set(this.qdo.workflowEndTime, (Object)LocalDateTime.now());
                jpaUpdateClause.set(this.qdo.workflowProcInstStatus, (Object)ProcInstStatus.APPROVED);
                SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(invoiceRedraftDO.getOrigApplyNo());
                List<SaleInvdDtlVO> saleInvdDtlVOs = this.saleInvService.getInvdLists(saleInvDO.getId());
                if (CollectionUtils.isEmpty(saleInvdDtlVOs)) break;
                InvoiceApplyRpcDTO applyRpcDTO = this.invoiceApplyService.queryIdByApplyNo(invoiceRedraftDO.getOrigApplyNo());
                SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
                InvoiceRedApplySaveParam saveParam = new InvoiceRedApplySaveParam();
                saveParam.setOriginApplyNo(invoiceRedraftDO.getOrigApplyNo());
                saveParam.setSaleTaxNo(saleInvDO.getSaleTaxNo());
                saveParam.setCustTaxNo(saleInvDO.getCustTaxNo());
                saveParam.setInvType(saleInvDO.getInvType());
                saveParam.setInvDate(saleInvdDtlVO.getInvDate());
                saveParam.setInvNo(saleInvdDtlVO.getInvNo());
                this.aisinoRedMethod(saveParam, applyRpcDTO.getApplyNo());
            }
        }
        jpaUpdateClause.execute();
        saleInvdDtlDOJpaUpdateClause.execute();
        return WorkflowResult.success(null);
    }

    public void aisinoRedMethod(InvoiceRedApplySaveParam saveParam, String applyNo) {
        String aisinoRedPayload = this.aisinoPayloadService.convertRedInitial(saveParam);
        AisinoResultResp response = this.aisinoService.redInvoiceInitial(this.aisinoPayloadService.assembleAisinoPayload(aisinoRedPayload, saveParam.getSaleTaxNo()), aisinoRedPayload);
        AisinoResultResp.Data data = response.getDATA();
        if (data != null) {
            InvoiceRedInitialRespVO invoiceRedInitialRespVO = (InvoiceRedInitialRespVO)JSON.parseObject((String)data.getDATA(), InvoiceRedInitialRespVO.class);
            String aisinoRedPayload1 = this.aisinoPayloadService.convertRedSave(invoiceRedInitialRespVO);
            AisinoCoverParamPayload aisinoCoverParamPayload1 = this.aisinoPayloadService.assembleAisinoPayload(aisinoRedPayload1, saveParam.getSaleTaxNo());
            if (Objects.equals(invoiceRedInitialRespVO.getQRJKPBZ(), "Y")) {
                AisinoResultResp response2 = this.aisinoService.redInvoiceSave(aisinoCoverParamPayload1, aisinoRedPayload1);
                AisinoResultResp.Data data1 = response2.getDATA();
                InvoiceRedInitialRespVO invoiceRedInitialRespVO2 = (InvoiceRedInitialRespVO)JSON.parseObject((String)data1.getDATA(), InvoiceRedInitialRespVO.class);
            } else {
                AisinoResultResp response2 = this.aisinoService.redInvoiceSave(aisinoCoverParamPayload1, aisinoRedPayload1);
                AisinoResultResp.Data data1 = response2.getDATA();
                InvoiceRedSaveRespVO invoiceRedSaveRespVO = (InvoiceRedSaveRespVO)JSON.parseObject((String)data1.getDATA(), InvoiceRedSaveRespVO.class);
                InvoiceRedSaveRespVO.Data saveRespVODATA = invoiceRedSaveRespVO.getDATA();
                InvoiceRedSaveRespVO.Qrjkpfpqx qrjkpfpxx = saveRespVODATA.getQRJKPFPXX();
                AisinoRedInvoiceParam aisinoRedInvoiceParam = new AisinoRedInvoiceParam();
                aisinoRedInvoiceParam.setUUID(saveRespVODATA.getUUID());
                aisinoRedInvoiceParam.setFPQQLSH(qrjkpfpxx.getXSFNSRSBH() + RandomUtil.randomNumbers((int)30));
                aisinoRedInvoiceParam.setYFPHM(qrjkpfpxx.getFPHM());
                aisinoRedInvoiceParam.setHZFPXXQRDBH(saveRespVODATA.getHZFPXXQRDBH());
                aisinoRedInvoiceParam.setSFZZFP("N");
                aisinoRedInvoiceParam.setZZFPHM("");
                aisinoRedInvoiceParam.setFPDM("");
                aisinoRedInvoiceParam.setFPZLDM("");
                aisinoRedInvoiceParam.setXSFNSRSBH("");
                aisinoRedInvoiceParam.setTDYSLXDM("");
                String aisinoRedPayload2 = this.aisinoPayloadService.convertRedOpen(aisinoRedInvoiceParam);
                AisinoCoverParamPayload aisinoCoverParamPayload2 = this.aisinoPayloadService.assembleAisinoPayload(aisinoRedPayload2, saveParam.getSaleTaxNo());
                AisinoResultResp response3 = this.aisinoService.redInvoiceOpen(aisinoCoverParamPayload2, aisinoRedPayload2);
                AisinoResultResp.Data data2 = response3.getDATA();
                InvoiceRedInitialRespVO invoiceRedInitialRespVO3 = (InvoiceRedInitialRespVO)JSON.parseObject((String)data2.getDATA(), InvoiceRedInitialRespVO.class);
            }
        }
    }

    public InvoiceRedraftCallbackController(InvoiceRedraftRepo invoiceRedraftRepo, JPAQueryFactory jpaQueryFactory, SaleInvRepo saleInvRepo, SaleInvService saleInvService, InvoiceApplyService invoiceApplyService, SaleInvDtlRepoProc saleInvDtlRepoProc, InvoiceSaveService invoiceSaveService, AisinoService aisinoService, SaleInvRepoProc saleInvRepoProc, AisinoPayloadService aisinoPayloadService) {
        this.invoiceRedraftRepo = invoiceRedraftRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.saleInvRepo = saleInvRepo;
        this.saleInvService = saleInvService;
        this.invoiceApplyService = invoiceApplyService;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.invoiceSaveService = invoiceSaveService;
        this.aisinoService = aisinoService;
        this.saleInvRepoProc = saleInvRepoProc;
        this.aisinoPayloadService = aisinoPayloadService;
    }
}

