package com.elitesland.fin.application.convert.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeComPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangePageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeDO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeDTO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface AgingRangeConvert {
    AgingRangeConvert INSTANCE = Mappers.getMapper(AgingRangeConvert.class);

    /**
     * saveVO转换DO
     *
     * @param saveVO 入参
     * @return DO
     */
    AgingRangeDO saveVoToDo(AgingRangeSaveParam saveVO);

    /**
     * DO转换RespVO
     *
     * @param agreementDO 入参
     * @return RespVO
     */
    AgingRangeVO doToRespVo(AgingRangeDO agreementDO);

    /**
     * DO转换DTO
     *
     * @param agreementDO 入参
     * @return DTO
     */
    AgingRangeDTO doToDto(AgingRangeDO agreementDO);

    /**
     * DTO转换RespVO
     *
     * @param agreementDTO 入参
     * @return RespVO
     */
    AgingRangeVO dtoToRespVo(AgingRangeDTO agreementDTO);


    /**
     * comPageParam 转换 PageParam
     *
     * @param comPageParam 入参
     * @return
     */
    AgingRangePageParam comToPageParam(AgingRangeComPageParam comPageParam);

    /**
     * pagingVo转换ComPagingVo
     *
     * @param pagingVO 入参
     * @return ComPagingVO
     */
    AgingRangeComPagingVO voToComPagingVo(AgingRangePagingVO pagingVO);
}
