package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计期间控制")
public class InvSobAccountPeriodParam extends BaseModelParam {

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司编码")
    private List<String> ouCodeList;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("期间格式")
    private String periodStyle;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("年份")
    private String year;

    @ApiModelProperty("起始日期")
    private LocalDateTime activeStartTime;

    @ApiModelProperty("结束日期")
    private LocalDateTime activeEndTime;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionDate;
}
