package com.elitesland.fin.application.service.saobei;

import com.elitesland.fin.application.facade.param.saobei.param.SaobeiTradeParamVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiAccountDetailVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiTradeRespVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiTransRespVO;
import com.saobei.open.sdk.model.requst.allocate.*;
import com.saobei.open.sdk.model.response.allocate.*;

public interface SaobeiAccountService {

    /**
     * 分账关系
     */
    SaobeiAccountInAddResponse addAccountIn(String accountNoOut, String accountNoIn, Integer allocateScale) throws Exception;

    /**
     * 账户认证
     *
     * @param paramVO
     * @return
     * @throws Exception
     */
    SaobeiAccountAuthenticationResponse accountAuthentication(SaobeiAccountAuthenticationRequest paramVO) throws Exception;

    SaobeiAccountQueryResponse queryAccount(SaobeiAccountAuthenticationRequest paramVO) throws Exception;

    SaobeiAccountDetailVO queryAccountDetail(SaobeiAccountAuthenticationRequest paramVO) throws Exception;

    /**
     * 查询分账关系
     *
     * @param paramVO
     * @return
     * @throws Exception
     */
    SaobeiAccountInQueryResponse queryAccountIn(SaobeiAccountInQueryRequest paramVO) throws Exception;

    /**
     * 查询分账记录
     *
     * @param paramVO
     * @return
     * @throws Exception
     */
    SaobeiTradeRespVO queryTradesByDate(SaobeiTradeParamVO paramVO) throws Exception;

    /**
     * 更新结算账户信息
     *
     * @param request
     * @return
     */
    SaobeiAccountUpdateResponse updateAccount(SaobeiAccountUpdateRequest request) throws Exception;

    /**
     * 扫呗 - CBK账户中心
     *
     * @param accountNo
     * @return
     */
    String centerlink(String accountNo) throws Exception;

    /**
     * 扫呗 - 查询CBK账户余额
     *
     * @param accountNo
     * @return
     */
    String getBalance(String accountNo) throws Exception;

    /**
     * 扫呗 - CBK分账
     *
     * @param request
     * @throws Exception
     */
    SaobeiDoTransResponse dotrans(SaobeiDoTransRequest request) throws Exception;

    SaobeiTransRespVO doAlltrans(SaobeiDoTransRequest request) throws Exception;

    /**
     * 交易详情查询
     *
     * @param request
     * @return
     */
    SaobeiQueryOrderResponse queryOrder(SaobeiQueryOrderRequest request) throws Exception;

    boolean existFailTransByRootDocNo(String rootDocNo);
}
