package com.elitesland.fin.application.web.arorder;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArAgingReportDtlVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderDtlService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.arorder
 * @date 2022/4/12 13:18
 */
@RestController
@RequestMapping("/fin/arOrder")
@RequiredArgsConstructor
@Api(value = "应收单", tags = {"应收单"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_AR_ORDER, businessDoClass = ArOrderDO.class)
public class ArOrderController {

    private final ArOrderService arOrderService;
    private final ArOrderDtlService arOrderDtlService;
    @PostMapping("page")
    @ApiOperation("应收单列表查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "应收单分页",
            businessObjectType = FinBusinessObjectConstant.FIN_AR_ORDER,operationCode = FinBusinessObjectConstant.FIN_AR_ORDER_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<ArOrderVO>> page(@RequestBody ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderVO> res = arOrderService.page(arOrderPageParam);
        return ApiResult.ok(res);
    }

    @GetMapping("get")
    @ApiOperation("获取单个应收单详情")
    public ApiResult<ArOrderVO> get(Long id) {
        ArOrderVO res = arOrderService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("dtlPage")
    @ApiOperation("分页查询明细信息")
    public ApiResult<PagingVO<ArOrderDtlVO>> detailPage(@RequestBody ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlVO> res = arOrderDtlService.page(arOrderDtlPageParam);
        return ApiResult.ok(res);
    }

    @DeleteMapping("del")
    @ApiOperation("删除应收单")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        ApiResult<Long> res = arOrderService.del(ids);
        return res;
    }

    @GetMapping("getForDtl")
    @ApiOperation("获取应付单详情和明细信息汇总信息")
    public ApiResult<ArOrderVO> getForDtl(Long id) {
        ArOrderVO res = arOrderService.getArOrderAndDtl(id);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增-应收单")
    public ApiResult<Long> save(@RequestBody ArOrderSaveParam arOrderSaveParam) {
        return arOrderService.save(arOrderSaveParam);
    }

    @PostMapping("update")
    @ApiOperation("修改-应收单")
    public ApiResult<Long> update(@RequestBody ArOrderSaveParam arOrderSaveParam) {
        return arOrderService.update(arOrderSaveParam);
    }

    @PostMapping("commit")
    @ApiOperation("提交-应收单")
    public ApiResult<Long> commit(@RequestBody ArOrderSaveParam arOrderSaveParam) {
        return arOrderService.commit(arOrderSaveParam);
    }

    @PostMapping("/cancel")
    @ApiOperation("取消-应收单")
    public ApiResult<Void> cancel(@RequestBody List<Long> ids) {
        return arOrderService.cancelApprove(ids);
    }

    @PostMapping("/red/punch/{id}")
    @ApiOperation("红冲-redPunch")
    public ApiResult<Long> redPunch(@PathVariable Long id) {
        return arOrderService.redPunch(id);
    }

    @PostMapping("autoCreate")
    @ApiOperation("自动生成应收单")
    public ApiResult<Void> autoCreate(@RequestBody ArOrderRecordSaveParam arOrderRecordSaveParam) {
        return arOrderService.autoCreate(arOrderRecordSaveParam);
    }

    @PostMapping("writeoff/page")
    @ApiOperation("应收单待核销列表")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "应收单待核销分页",
            businessObjectType = FinBusinessObjectConstant.FIN_AR_ORDER,operationCode = FinBusinessObjectConstant.FIN_AR_ORDER_WRITE_OFF_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    ApiResult<PagingVO<ArOrderVO>> writeoffPage(@RequestBody ArOrderPageParam arOrderPageParam) {
        //ApiResult.ok(arOrderExService.page(arOrderExPageParam));
        PagingVO<ArOrderVO> res = arOrderService.writeoffPage(arOrderPageParam);
        return ApiResult.ok(res);
    }
    @PostMapping("agingReport/detail")
    @ApiOperation("应收账龄分析明细报表")
    ApiResult<PagingVO<ArOrderVO>> agingReportDetail(@RequestBody ArAgingReportDtlVO arAgingReportDtlVO) {
        //ApiResult.ok(arOrderExService.page(arOrderExPageParam));
        //PagingVO<ArOrderVO> res = arOrderService.writeoffPage(arOrderPageParam);
        //return ApiResult.ok(res);
        return null;
    }
}
