package com.elitesland.fin.domain.entity.saleinv;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Entity
@Table(name="sale_invd_dtl")
@org.hibernate.annotations.Table(appliesTo = "sale_invd_dtl", comment = "销售已开发票明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SaleInvdDtlDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    @Column(name = "inv_no", columnDefinition = "varchar(32) comment '发票号码'")
    private String invNo;

    @Column(name = "inv_code", columnDefinition = "varchar(32) comment '发票代码'")
    private String invCode;

    @Column(name = "flow_no", columnDefinition = "varchar(32) comment '流水号'")
    private String flowNo;

    @Column(name = "check_code", columnDefinition = "varchar(32) comment '校验码'")
    private String checkCode;

    @Column(name = "blue_inv_code", columnDefinition = "varchar(32) comment '原蓝票代码'")
    private String blueInvCode;

    @Column(name = "blue_inv_no", columnDefinition = "varchar(32) comment '原蓝票号码'")
    private String blueInvNo;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '开票金额'")
    private BigDecimal totalAmt;

    @Column(name = "inv_date", columnDefinition = "datetime(6) comment '开票日期'")
    private LocalDateTime invDate;

    @Column(name = "red_state", columnDefinition = "varchar(32) comment '红冲状态'")
    private String redState;

    @Column(name = "inv_state", columnDefinition = "varchar(32) comment '开票状态'")
    private String invState;

    @Column(name = "inv_pdf_url", columnDefinition = "varchar(256) comment 'pdf链接'")
    private String invPdfUrl;

    @Column(name = "inv_pdf_base64", columnDefinition = "longtext comment 'Base64数据'")
    private String invPdfBase64;

    @Column(name = "inv_fail_cause", columnDefinition = "varchar(128) comment '开票失败原因'")
    private String invFailCause;

    @Column(name = "invoice_redraft_state", columnDefinition = "varchar(32) comment '换开审核状态'")
    private String invoiceRedraftState;

    @Column(name = "sale_tax_no", columnDefinition = "varchar(32) comment '销售方税号'")
    private String saleTaxNo;

    @Column(name = "original_content", columnDefinition = "longtext comment '开票源数据'")
    private String originalContent;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaleInvdDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SaleInvdDtlDO entity = (SaleInvdDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}