package com.elitesland.fin.infinity.utils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2021/07/12
 */
public class StringFormatUtil {

    /**
     * 字符串添加括号
     */
    public static String bracket(Object obj) {
        return "\"" + defaultValue(obj) + "\"";
    }

    /**
     * 追加默认值
     */
    public static String defaultValue(Object obj) {
        return Optional.ofNullable(obj).orElse("").toString();
    }

    /**
     * 多数据用英文逗号分隔，责任人：丁强 2018年9月7日 17点14分
     */
    private final static String DEFAULT_SEPARATOR = ",";

    /**
     * 只支持Short、Integer、String
     * 把list的每一项的toString的值通过默认分隔符分开拼接起来
     *
     * @param list 传入列表
     * @return 拼接后的字符串
     */
    public static String stitch2String(List list) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return "";
        } else {
            StringBuilder str = new StringBuilder();
            for (Object o : list) {
                str.append(o.toString()).append(DEFAULT_SEPARATOR);
            }
            str.deleteCharAt(str.length() - 1);
            return str.toString();
        }
    }
}
