/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleValueVO;
import com.elitesland.fin.application.service.accountingengine.FinFlexibleValueService;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookLineService;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookService;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinFlexibleValueServiceImpl
implements FinFlexibleValueService {
    private static final Logger log = LoggerFactory.getLogger(FinFlexibleValueServiceImpl.class);
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinSetOfBookService finSetOfBookService;
    private final FinSetOfBookLineService finSetOfBookLineService;

    @Override
    @SysCodeProc
    public PagingVO<FinFlexibleValueVO> page(FinFlexibleValueParam finFlexibleValueParam) {
        List<FinFlexibleDO> allByFlexibleCode;
        if (finFlexibleValueParam.getMasId() == null && StringUtils.isNotBlank((CharSequence)finFlexibleValueParam.getFlexibleCode()) && (allByFlexibleCode = this.finFlexibleRepo.findAllByFlexibleCode(finFlexibleValueParam.getFlexibleCode())).size() > 0) {
            finFlexibleValueParam.setMasId(allByFlexibleCode.get(0).getId());
        }
        return FinFlexibleValueConvert.INSTANCE.DTOToVO(this.finFlexibleValueRepoProc.page(finFlexibleValueParam));
    }

    @Override
    @SysCodeProc
    public PagingVO<FinFlexibleValueVO> pageBySetOfBook(FinFlexibleValueParam finFlexibleValueParam) {
        List<FinFlexibleDO> allByFlexibleCode;
        if (StringUtils.isBlank((CharSequence)finFlexibleValueParam.getSobCode())) {
            throw new BusinessException("\u8d26\u5957\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)finFlexibleValueParam.getColumnName())) {
            throw new BusinessException("\u6838\u7b97\u7ef4\u5ea6\u5b57\u6bb5\u540d\u79f0\u4e3a\u7a7a");
        }
        FinSetOfBookDTO finSetOfBookDTO = this.finSetOfBookService.findBySobCode(finFlexibleValueParam.getSobCode());
        if (finSetOfBookDTO == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d26\u5957");
        }
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = this.finSetOfBookLineService.findByMasId(finSetOfBookDTO.getId());
        if (CollectionUtils.isEmpty(finSetOfBookLineDTOList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d26\u5957\u660e\u7ec6");
        }
        Optional<FinSetOfBookLineDTO> first = finSetOfBookLineDTOList.stream().filter(v -> v.getColumnName().equals(finFlexibleValueParam.getColumnName())).findFirst();
        if (!first.isPresent()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d26\u5957\u660e\u7ec6");
        }
        FinSetOfBookLineDTO finSetOfBookLineDTO = first.get();
        if (!Boolean.TRUE.equals(finSetOfBookLineDTO.getFlexibleFlag())) {
            throw new BusinessException("\u8d26\u5957\u660e\u7ec6\u6ca1\u6709\u503c\u96c6\u6807\u8bc6");
        }
        if (StringUtils.isBlank((CharSequence)finSetOfBookLineDTO.getFlexibleCode())) {
            throw new BusinessException("\u8d26\u5957\u660e\u7ec6\u503c\u96c6\u7f16\u7801\u4e3a\u7a7a");
        }
        finFlexibleValueParam.setFlexibleCode(finSetOfBookLineDTO.getFlexibleCode());
        if (finFlexibleValueParam.getMasId() == null && StringUtils.isNotBlank((CharSequence)finFlexibleValueParam.getFlexibleCode()) && (allByFlexibleCode = this.finFlexibleRepo.findAllByFlexibleCode(finFlexibleValueParam.getFlexibleCode())).size() > 0) {
            finFlexibleValueParam.setMasId(allByFlexibleCode.get(0).getId());
        }
        return FinFlexibleValueConvert.INSTANCE.DTOToVO(this.finFlexibleValueRepoProc.page(finFlexibleValueParam));
    }

    @Override
    public Map<String, Map<String, FinFlexibleValueVO>> listBySetOfBook(FinFlexibleValueParam finFlexibleValueParam) {
        if (CollectionUtils.isEmpty(finFlexibleValueParam.getSobCodes())) {
            return new HashMap<String, Map<String, FinFlexibleValueVO>>();
        }
        List<FinSetOfBookDTO> finSetOfBookDTOS = this.finSetOfBookService.findBySobCodes(finFlexibleValueParam.getSobCodes());
        if (CollectionUtils.isEmpty(finSetOfBookDTOS)) {
            return new HashMap<String, Map<String, FinFlexibleValueVO>>();
        }
        List<Long> masIds = finSetOfBookDTOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = this.finSetOfBookLineService.findByMasIds(masIds);
        if (CollectionUtils.isEmpty(finSetOfBookLineDTOList)) {
            return new HashMap<String, Map<String, FinFlexibleValueVO>>();
        }
        List<String> flexibleCodes = finSetOfBookLineDTOList.stream().filter(v -> Boolean.TRUE.equals(v.getFlexibleFlag()) && StringUtils.isNotBlank((CharSequence)v.getFlexibleCode())).map(v -> v.getFlexibleCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(flexibleCodes)) {
            return new HashMap<String, Map<String, FinFlexibleValueVO>>();
        }
        List<FinFlexibleDO> finFlexibleDOS = this.finFlexibleRepo.findAllByFlexibleCodeIn(flexibleCodes);
        if (CollectionUtils.isEmpty(finFlexibleDOS)) {
            return new HashMap<String, Map<String, FinFlexibleValueVO>>();
        }
        List<Long> flexibleIds = finFlexibleDOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        finFlexibleValueParam.setMasIds(flexibleIds);
        finFlexibleValueParam.setSize(Integer.MAX_VALUE);
        PagingVO<FinFlexibleValueVO> finFlexibleValueVOPagingVO = FinFlexibleValueConvert.INSTANCE.DTOToVO(this.finFlexibleValueRepoProc.page(finFlexibleValueParam));
        if (finFlexibleValueVOPagingVO.isEmpty()) {
            return new HashMap<String, Map<String, FinFlexibleValueVO>>();
        }
        List finFlexibleValueDOList = finFlexibleValueVOPagingVO.getRecords();
        HashMap<String, Map<String, FinFlexibleValueVO>> flexCodeValueMap = new HashMap();
        Map<String, Long> flexCodeIdMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> v.getId(), (o, n) -> n));
        Map flexibleValueMap = finFlexibleValueDOList.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        flexCodeValueMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> flexibleValueMap.get(v.getId()) != null ? ((List)flexibleValueMap.get(v.getId())).stream().collect(Collectors.toMap(w -> w.getFlexibleValueCode(), w -> w, (o, n) -> n)) : null, (o, n) -> n));
        return flexCodeValueMap;
    }

    public FinFlexibleValueServiceImpl(FinFlexibleValueRepo finFlexibleValueRepo, FinFlexibleValueRepoProc finFlexibleValueRepoProc, FinFlexibleRepo finFlexibleRepo, FinSetOfBookService finSetOfBookService, FinSetOfBookLineService finSetOfBookLineService) {
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finFlexibleValueRepoProc = finFlexibleValueRepoProc;
        this.finFlexibleRepo = finFlexibleRepo;
        this.finSetOfBookService = finSetOfBookService;
        this.finSetOfBookLineService = finSetOfBookLineService;
    }
}

