package com.elitesland.fin.infr.repo.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;
import com.elitesland.fin.domain.entity.paymentperiod.QAgingRangeDtlDO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class AgingRangeDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAgingRangeDtlDO qAgingRangeDtlDO = QAgingRangeDtlDO.agingRangeDtlDO;

    public PagingVO<AgingRangeDtlDTO> page(AgingRangeDtlPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AgingRangeDtlDTO> query = select(AgingRangeDtlDTO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qAgingRangeDtlDO);
        return PagingVO.<AgingRangeDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<AgingRangeDtlVO> selectListByParam(AgingRangeDtlPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AgingRangeDtlVO> query = select(AgingRangeDtlVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }


    private List<Predicate> where(AgingRangeDtlPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();


        if (!StringUtils.isEmpty(pageParam.getPaymentPeriodDesc())) {
            predicates.add(qAgingRangeDtlDO.paymentPeriodDesc.eq(pageParam.getPaymentPeriodDesc()));
        }


        if (Objects.nonNull(pageParam.getId())){
            predicates.add(qAgingRangeDtlDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qAgingRangeDtlDO.id.in(pageParam.getIdList()));
        }
        if (Objects.nonNull(pageParam.getMasId())){
            predicates.add(qAgingRangeDtlDO.masId.eq(pageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIdList())) {
            predicates.add(qAgingRangeDtlDO.masId.in(pageParam.getMasIdList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAgingRangeDtlDO.id,
                qAgingRangeDtlDO.masId,
                qAgingRangeDtlDO.lineNo,
                qAgingRangeDtlDO.paymentPeriodDesc,
                qAgingRangeDtlDO.paymentPeriodBegin,
                qAgingRangeDtlDO.paymentPeriodEnd,
                qAgingRangeDtlDO.totalPeriod,
                qAgingRangeDtlDO.remark,
                qAgingRangeDtlDO.createTime,
                qAgingRangeDtlDO.createUserId,
                qAgingRangeDtlDO.creator,
                qAgingRangeDtlDO.modifyTime,
                qAgingRangeDtlDO.modifyUserId,
                qAgingRangeDtlDO.updater,
                qAgingRangeDtlDO.deleteFlag
        )).from(qAgingRangeDtlDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        jpaQueryFactory.update(qAgingRangeDtlDO)
                .set(qAgingRangeDtlDO.deleteFlag, deleteFlag)
                .where(qAgingRangeDtlDO.masId.in(masIds))
                .execute();
    }

}
