package com.elitesland.fin.rpc.ystsupp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/14
 * @Version 1.0
 * @Content:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RmiOrgStoreRpcServiceServiceImpl implements RmiOrgStoreRpcServiceService{
    private final OrgStoreRpcService orgStoreRpcService;


    /**
     * 查询门店基础信息接口
     *
     * @param storeCodeList 公司编号
     * @return
     */
    @Override
    public List<OrgStoreBaseRpcDTO> findBaseStoreByCodes(List<String> storeCodeList) {
        if (CollectionUtil.isEmpty(storeCodeList)) {
            return Collections.EMPTY_LIST;
        }
        try {
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setStoreCodeList(storeCodeList);
            ApiResult<List<OrgStoreBaseRpcDTO>> apiResult = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
            if (apiResult.isSuccess()) {
                List<OrgStoreBaseRpcDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用基础域(findOrgStoreBaseByParam)查询门店失败：" + apiResult.getErrorMsg());
            }

        } catch (Exception e) {
            log.error("findBaseOuByCodes error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用基础中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,OrgStoreBaseRpcDTO> findBaseStoreMapByCodes(List<String> storeCodeList) {

        List<OrgStoreBaseRpcDTO> rpcDTOList = this.findBaseStoreByCodes(storeCodeList);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, OrgStoreBaseRpcDTO> ouMap = rpcDTOList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1));

        return ouMap;

    }

    @Override
    public List<OrgBankRpcDTO> findBankByStoreCode(String storeCode) {
        log.info("门店编码查询银行信息,入参:{}", storeCode);
        List<OrgBankRpcDTO> bankByStoreCode = null;
        try {
            bankByStoreCode = orgStoreRpcService.findBankByStoreCode(storeCode);
        } catch (Exception e) {
            log.error("调用基础域,门店编码查询银行信息，异常" + e.getMessage());
            throw new BusinessException("调用基础域,门店编码查询银行信息异常", e);
        }
        log.info("门店编码查询银行信息,结果:{}", JSONUtil.toJsonStr(bankByStoreCode));
        if (CollectionUtil.isEmpty(bankByStoreCode)) {
            return new ArrayList<>();
        }
        return bankByStoreCode;
    }
}
