package com.elitesland.fin.application.service.excel.entity;

import com.elitesland.fin.application.facade.excel.convert.*;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ArExportEntity implements Serializable {
    private Long id;
    @ApiModelProperty("来源单号")
    private String sourceNo;
    
    @ApiModelProperty("应收单编号")
    private String arOrderNo;
    
    @ApiModelProperty("销售公司编码")
    private String ouCode;
    
    @ApiModelProperty("销售公司名称")
    private String ouName;
    
    @ApiModelProperty("单据来源")
    private String createMode;
    private String createModeName;
    
    @ApiModelProperty("应收单类型名称")
    private String arTypeName;
    
    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;
    
    @ApiModelProperty("单据状态")
    private String orderState;
    private String orderStateName;
    
    @ApiModelProperty("业务日期")
    @ExcelConvert(converter = DateTimeToDateConverter.class)
    private Object buDate;
    
    @ApiModelProperty("含税金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object totalAmt;
    
   
    @ApiModelProperty("不含税金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object exclTaxAmt;
    
    @ApiModelProperty("税额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object taxAmt;
    
    
    @ApiModelProperty("含税金额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object totalCurAmt;
    
    
    @ApiModelProperty("不含税金额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object exclTaxCurAmt;
    
    
    @ApiModelProperty("税额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object taxCurAmt;
    
    
    @ApiModelProperty("币种编码")
    private String currCode;
    
    @ApiModelProperty("币种")
    private String currName;
    
    @ApiModelProperty("本位币编码")
    private String localCurrCode;
    
    @ApiModelProperty("本位币名称")
    private String localCurrName;
    
    @ApiModelProperty("审核人")
    private String auditUser;
    
    @ApiModelProperty("审核日期")
    private LocalDateTime auditDate;
    
    @ApiModelProperty("汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal exchangeRate;
    
    @ApiModelProperty("是否含税")
    private Boolean taxFlag;
    
    @ApiModelProperty("是否期初")
    private Boolean initFlag;
    
    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;
    
    @ApiModelProperty("客户编码")
    private String custCode;
    
    @ApiModelProperty("客户名称")
    private String custName;
    
    @ApiModelProperty("部门编码")
    private String buCode;
    
    @ApiModelProperty("部门名称")
    private String buName;
    
    @ApiModelProperty("业务类型")
    private String buType;
    
    @ApiModelProperty("核销状态")
    private String verState;
    private String verStateName;
    
    @ApiModelProperty("已核销金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object verAmt;
    
    @ApiModelProperty("未核销金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object unVerAmt;
    
    @ApiModelProperty("备注")
    private String remark;
    
    @ApiModelProperty("组织编码")
    private String orgCode;
    
    @ApiModelProperty("组织名称")
    private String orgName;
    
    @ApiModelProperty("销售业务员")
    private String saleUser;
    
    @ApiModelProperty("单据类型")
    private String arOrderType;
    
    @ApiModelProperty("总数量")
    @JsonSerialize(using = QuantityRoundConverter.class)
    private BigDecimal totalCount;
    
    @ApiModelProperty(value = "创建人")
    private String creator;
    
    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;
    
    @ApiModelProperty(value = "修改人")
    private String updater;
    
    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("具体订单场景")
    private String docType;
    
    @ApiModelProperty("B端订单/C端订单")
    private String docType2;
    
    @ApiModelProperty("SO代表正向RSO代表退货负向")
    private String docCls;
    
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    
    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;
    
    @ApiModelProperty("结算方式")
    private String settlementType;
    private String settlementTypeName;
    
    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    private String proposedStatus;
    private String proposedStatusName;
    
    @ApiModelProperty("红冲状态")
    private Object redState;
    
    @ApiModelProperty("红冲单对应原单号")
    private String redSourceNo;
    
    /** detail data **/
    
    @ApiModelProperty("明细来源单号")
    private String detailSourceNo;
    
    @ApiModelProperty("明细来源行号")
    private Integer detailSourceLine;
    
    @ApiModelProperty("商品编码")
    private String itemCode;
    
    @ApiModelProperty("商品名称")
    private String itemName;
    
    @ApiModelProperty("规格型号")
    private String itemType;
    
    @ApiModelProperty("小类编码")
    private String smallCateCode;
    
    @ApiModelProperty("小类名称")
    private String smallCateName;
    
    @ApiModelProperty("计量单位")
    private String uom;
    
    @ApiModelProperty("计量单位名称")
    private String uomName;
    
    @ApiModelProperty("数量")
    @ExcelConvert(converter = QuantityRoundConverter.class)
    private Object detailQty;
    
    
    @ApiModelProperty("明细单价")
    @ExcelConvert(converter = PriceRoundConverter.class)
    private Object detailExclTaxPrice;
    
    
    @ApiModelProperty("明细含税单价")
    @ExcelConvert(converter = PriceRoundConverter.class)
    private Object detailPrice;
    
    
    @ApiModelProperty("明细税率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal detailTaxRate;
    
    @ApiModelProperty("明细含税金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object detailTotalAmt;
    
    
    @ApiModelProperty("明细不含税金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object detailExclTaxAmt;
    
    
    @ApiModelProperty("明细税额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object detailTaxAmt;
    
    
    @ApiModelProperty("明细含税金额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object detailTotalCurAmt;
    
    
    @ApiModelProperty("明细不含税金额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object detailExclTaxCurAmt;
    
    
    @ApiModelProperty("明细税额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object detailTaxCurAmt;
    
    
    @ApiModelProperty("费用部门")
    private String detailBuName;
    
    @ApiModelProperty("费用类型")
    private String expensesType;
    private String expensesTypeName;
    
    @ApiModelProperty("明细行备注")
    private String detailRemark;
}
