package com.elitesland.fin.infr.repo.arorder;

import com.elitesland.fin.domain.entity.arorder.ArOrderDtlRecordDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/28
 * @Version 1.0
 * @Content:
 */
@Repository
public interface ArOrderDtlRecordRepo extends JpaRepository<ArOrderDtlRecordDO, Long>, QuerydslPredicateExecutor<ArOrderDtlRecordDO> {

    /**
     * 根据主表id查询应收单明细记录表明细
     * @param masId 主表id
     * @return
     */
    List<ArOrderDtlRecordDO> findAllByMasId(Long masId);

    /**
     * 根据主表id集合查询应收单明细记录表明细
     * @param masIdList 主表id集合
     * @return
     */
    List<ArOrderDtlRecordDO> findAllByMasIdIn(List<Long> masIdList);

    /**
     * 根据主表id集合删除应收单明细记录表明细
     * @param masIdList 主表id集合
     * @return
     */
    void deleteAllByMasIdIn(List<Long> masIdList);
}
