/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceIssueUtil {
    private static final Logger log = LoggerFactory.getLogger(InvoiceIssueUtil.class);
    private static CloseableHttpClient httpClient;

    public static void main(String[] arg) throws Exception {
        String DataJson = "";
        String IssInfo = InvoiceIssueUtil.issue(DataJson);
        System.out.println(IssInfo);
    }

    public static String issue(String jsondata) throws Exception {
        String appid = "";
        String appkey = "";
        String requestUrl = "";
        String jsonstr = jsondata;
        byte[] result = InvoiceIssueUtil.encrypt(jsonstr.getBytes(), appkey);
        String content = InvoiceIssueUtil.byteToHexString(result);
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("APPID", appid);
        req.put("DATA", content);
        String reqJson = JSONObject.toJSONString(req);
        String res = InvoiceIssueUtil.post(requestUrl, reqJson);
        Map map = (Map)JSONObject.parse((String)res);
        String Data2 = (String)map.get("DATA");
        byte[] ttb = InvoiceIssueUtil.parseHexStr2Byte(Data2);
        byte[] decryResult = InvoiceIssueUtil.decrypt(ttb, appkey);
        return new String(decryResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String post(String url, String jsonString) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(jsonString, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            result = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static byte[] encrypt(byte[] datasource, String password) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)securekey, random);
            return cipher.doFinal(datasource);
        }
        catch (Throwable e) {
            log.error("\u52a0\u5bc6\u5f02\u5e38", e);
            return null;
        }
    }

    public static String byteToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bytes[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static byte[] decrypt(byte[] src, String password) throws Exception {
        SecureRandom random = new SecureRandom();
        DESKeySpec desKey = new DESKeySpec(password.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)securekey, random);
        return cipher.doFinal(src);
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        cm.setDefaultMaxPerRoute(50);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

