package com.elitesland.fin.application.facade.param.flowrepair;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "creditAccountFlowRepairPageParam",description = "信用账户流水修复重算分页查询入参")
public class CreditAccountFlowRepairPageParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 179036843520963301L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID集合")
    private List<Long> ids;

    @ApiModelProperty(value = "流水号")
    private String flowNo;
    @ApiModelProperty(value = "流水号集合")
    private List<String> flowNoList;

    @ApiModelProperty(value = "实际金额")
    private BigDecimal actualAmount;

    @ApiModelProperty(value = "原流水发生金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "开户主体编码")
    private String openAccountEntityCode;

    @ApiModelProperty(value = "开户主体名称")
    private String openAccountEntityName;

    @ApiModelProperty(value = "开户主体编码/名称模糊查询")
    private String openAccountEntityKeyword;

    @ApiModelProperty(value = "开户主体编码集合")
    private List<String> openAccountEntityCodeList;

    @ApiModelProperty(value = "信用账户类型")
    private String accountType;

    @ApiModelProperty(value = "信用账户类型集合")
    private List<String> accountTypeList;

    @ApiModelProperty(value = "账户编码")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty(value = "账户编码/名称模糊查询")
    private String accountKeyword;

    @ApiModelProperty(value = "账户编码集合")
    private List<String> accountCodeList;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "来源单号集合")
    private List<String> sourceNoList;

    @ApiModelProperty(value = "修复状态")
    private String repairStatus;

    @ApiModelProperty(value = "修复状态集合")
    private List<String> repairStatusList;

    @ApiModelProperty(value = "重算原因")
    private String recalculationReason;

    @ApiModelProperty(value = "重算原因集合")
    private List<String> recalculationReasonList;

    @ApiModelProperty(value = "重算日期")
    private LocalDateTime recalculationDate;

    @ApiModelProperty(value = "重算日期开始")
    private LocalDateTime recalculationDateStart;

    @ApiModelProperty(value = "重算日期结束")
    private LocalDateTime recalculationDateEnd;

    @ApiModelProperty("重算人")
    private String recalculationUser;

    @ApiModelProperty("重算人ID")
    private Long recalculationUserId;
}
