package com.elitesland.fin.application.service.invoice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;

import java.util.List;

public interface InvoiceDtlDomainService {

    /**
     * 获取指定主表ID的销售明细列表。
     *
     * @param masId 主表的ID，用于查询相关的销售明细记录。
     * @return 返回一个SaleInvDtlDTO对象的列表，包含了指定主表ID的所有销售明细记录。
     */
    List<SaleInvDtlDTO> getList(Long masId);

    PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam);
}
