package com.elitesland.fin.entity.expense;

/**
 * @author Mark
 * @date 2024/08/13 14:23
 */

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

@Entity
@Table(name = "expense_rule_config")
@org.hibernate.annotations.Table(appliesTo = "expense_rule_config", comment = "费用计算规则配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
@ApiModel(value = "expense_rule_config", description = "费用计算规则配置")
public class ExpRuleConfigDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -3868184646594562482L;

    @ApiModelProperty("规则编码")
    @Column(name = "rule_code", columnDefinition = "varchar(32)  comment '规则编码'")
    private String ruleCode;

    @ApiModelProperty("规则名称")
    @Column(name = "rule_name", columnDefinition = "varchar(32)  comment '规则名称'")
    private String ruleName;

    @ApiModelProperty("费用类型编码")
    @Column(name = "exp_type_code", columnDefinition = "varchar(32)  comment '费用类型编码'")
    private String expTypeCode;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;
    
    @ApiModelProperty("计算方式 1固定金额/2固定比例")
    @Column(name = "calculate_type", columnDefinition = "varchar(32) comment '计算方式 1固定金额/2固定比例'")
    private String calculateType;

    @ApiModelProperty("计算比例")
    @Column(name = "calculate_percent", columnDefinition = "decimal(20,8) comment '计算比例'")
    private BigDecimal calculatePercent;

    @ApiModelProperty("计算比例金额来源")
    @Column(name = "calculate_percent_src", columnDefinition = "varchar(16) comment '计算比例金额来源'")
    private String calculatePercentSrc;

    @ApiModelProperty("单位金额")
    @Column(name = "uom_amt", columnDefinition = "decimal(20,8) comment '单位金额'")
    private BigDecimal uomAmt;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(16) comment '单位'")
    private String uom;

    @ApiModelProperty(value = "台账自动审核 1-是 0-否")
    @Column(name = "automatic_review", columnDefinition = "tinyint(1)  comment '台账自动审核 Y-是 N-否'")
    private boolean automaticReview;

    @ApiModelProperty("生效日期")
    @Column(name = "valid_date", columnDefinition = "date comment '生效日期'")
    private LocalDate validDate;

    @ApiModelProperty(value = "执行序列")
    @Column(name = "priority_no", columnDefinition = "int(6)  comment '执行序列'")
    private Integer priorityNo;

    @ApiModelProperty("费用元素")
    @Column(name = "exp_element", columnDefinition = "varchar(255) comment '费用元素'")
    private String expElement;
}