package com.elitesland.fin.application.facade.param.common;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class FinQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者用户ID")
    private Long createUserId;


    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间起")
    private LocalDateTime createTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间止")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("修改者用户ID")
    private Long modifyUserId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间起")
    private LocalDateTime modifyTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间止")
    private LocalDateTime modifyTimeEnd;

    public FinQueryParam() {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        defaultOrder(orderItem);
    }
}
