package com.elitesland.fin.application.facade.vo.adjusttoorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:49
 */
@Data
public class AdjustToOrderVO extends CustomFieldBaseModelVo {

    @ApiModelProperty("单号")
    private String docNo;

    @SysCode(sys = "yst-supp",mod = "APPLY_STATUS")
    @ApiModelProperty("单据状态")
    private String docState;
    private String docStateName;

    @ApiModelProperty("从账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accountTypeFrom;
    private String accountTypeFromName;

    @ApiModelProperty("从账户编码")
    private String accountCodeFrom;

    @ApiModelProperty("从账户名称")
    private String accountNameFrom;

    @ApiModelProperty("至账户名称")
    private String accountNameTo;

    @ApiModelProperty("至账户类型")
    private String accountTypeTo;
    private String accountTypeToName;

    @ApiModelProperty("至账户编码")
    private String accountCodeTo;

    @ApiModelProperty("调整原因")
    @SysCode(sys = "yst-fin",mod = "ADJUST_REASON")
    private String adjustReason;
    private String adjustReasonName;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustAmount;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;
}
