package com.elitesland.fin.entity.payment;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Entity
@Table(name = "payment_rule_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "payment_rule_config_dtl", comment = "支付配置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
@ApiModel(value = "payment_rule_config_dtl", description = "支付配置明细")
public class PaymentRuleConfigDtlDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6829086191452645974L;

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @ApiModelProperty("扣款单据类型")
    @Column(name = "opt_doc_type", columnDefinition = "varchar(32)  comment '扣款单据类型'")
    private String optDocType;

    @ApiModelProperty("扣款单据状态")
    @Column(name = "opt_doc_status", columnDefinition = "varchar(32)  comment '扣款单据状态'")
    private String optDocStatus;

    @ApiModelProperty("扣款账户类型")
    @Column(name = "opt_account_type", columnDefinition = "varchar(32)  comment '扣款账户类型'")
    private String optAccountType;

    @ApiModelProperty("最高扣款比例")
    @Column(name = "calculate_percent", columnDefinition = "decimal(18,2) comment '最高扣款比例'")
    private BigDecimal calculatePercent;

    @ApiModelProperty("优先级")
    @Column(name = "priority_no", columnDefinition = "int(11) comment '优先级'")
    private Integer priorityNo;

}