package com.elitesland.fin.infr.factory.aporder;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.factory.aporder
 * @date 2022/3/17 15:18
 */
@RequiredArgsConstructor
@Component
public class ApOrderFactory {

    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;

    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        List<Long> dtlMasIds = StringUtils.isBlank(apOrderPageParam.getSourceNoDtl()) ? new ArrayList<>() :
                apOrderDtlRepoProc.findBySourceId(apOrderPageParam.getSourceNoDtl());

        List<Long> masIdList = apOrderDtlRepoProc.findBySourceNoList(apOrderPageParam.getDtlSourceNoList());
        List<Long> masIdAllList = Stream.of(dtlMasIds, masIdList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        PagingVO<ApOrderDTO> page = apOrderRepoProc.page(apOrderPageParam, masIdAllList);
        page.getRecords().forEach(x ->
                //计算总数量
                x.setTotalCount(apOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO, BigDecimal::add))
        );
        return page;
    }
    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        List<Long> masIds = apOrderDtlRepoProc.findUnverBySourceId(apOrderPageParam);
        PagingVO<ApOrderDTO> page=null;
        //如果为空直接返回空
        if (CollUtil.isEmpty(masIds)) {
            return new PagingVO<>(0,new ArrayList<>());
        } else {
            //不为空加上主键ID作为查询条件
            page = apOrderRepoProc.unverPage(apOrderPageParam, masIds);
        }
       /* page.getRecords().forEach(x ->
                //计算总数量
                x.setTotalCount(apOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO, BigDecimal::add))
        );*/
        return page;
    }

}
