package com.elitesland.fin.domain.service.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
public interface AgingRangeDtlDomainService {
    /**
     * 账龄区间明细保存
     *
     * @param saveParamList 入参
     * @return 账龄区间明细明细ID
     */
    List<Long> saveDtl(List<AgingRangeDtlSaveParam> saveParamList);

    /**
     * 根据主表ID删除账龄区间明细
     *
     * @param masId 主表ID
     * @return
     */
    void deleteByMasId(Long masId);


    /**
     * 根据主表ID查询账龄区间明细
     *
     * @param masId 主表ID
     * @return 账龄区间明细
     */
    List<AgingRangeDtlVO> selectByMasId(Long masId);

    /**
     * 根据入参查询账龄区间明细
     *
     * @param queryVO 入参
     * @return 账龄区间明细
     */
    List<AgingRangeDtlVO> selectByParam(AgingRangeDtlPageParam queryVO);


    /**
     * 根据主表ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表ID
     */
    void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds);
}
