package com.elitesland.fin.entity.creditaccount;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/01/08
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name="credit_auto_repayment_condition")
@org.hibernate.annotations.Table(appliesTo = "credit_auto_repayment_condition", comment = "信用设置自动还款条件")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class CreditAutoRepaymentConditionDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 3346114984916601138L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "serial_num", columnDefinition = "int(6) comment '序列号'")
    private Integer serialNum;

    @Column(name = "table_name", columnDefinition = "varchar(100) comment '表单名称'")
    private String tableName;

    @Column(name = "column_name", columnDefinition = "varchar(100) comment '字段名称'")
    private String columnName;

    @Column(name = "condition_type", columnDefinition = "varchar(40) comment '条件类型'")
    private String conditionType;

    @Column(name = "value_from", columnDefinition = "varchar(200) comment '从值内容'")
    private String valueFrom;

    @Column(name = "value_to", columnDefinition = "varchar(200) comment '至值内容'")
    private String valueTo;

}
