package com.elitesland.fin.repo.account;

import com.elitesland.fin.entity.account.AccountDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public interface AccountRepo extends JpaRepository<AccountDO, Long>, QuerydslPredicateExecutor<AccountDO> {

    AccountDO findByAccountCode(String accCode);

    List<AccountDO> findByAccountHolderName(String accountHolderName);

    List<AccountDO> findAllByAccountCode(String accountCode);

    boolean existsByAccountCode(String accountCode);

    boolean existsByAccountNameAndAccountType(String accountName, String accountType);

    boolean existsBySecOuCodeAndAccountHolderCodeAndAccountType(String secOuCode, String accountHolderCode, String accountType);

    boolean existsByAccountHolderCodeAndAccountType(String accountHolderCode, String accountType);
    @Modifying
    //@Query(value = "update fin_payment_records set delete_flag = :deleteFlag where id in :idList", nativeQuery = true)
    @Query(value = "update account  set account_occupancy_amount = account_occupancy_amount + :accountAmount,account_available_amount = account_available_amount - :accountAmount\n" +
            " where id =:id and account_available_amount >= :accountAmount", nativeQuery = true)
    int updateAccountOccupancyAmountAndAccountAvailableAmountById(long id, BigDecimal accountAmount);


    @Modifying
    @Query(value = "update account set account_amount = account_amount + :amount,account_available_amount = account_available_amount + :amount\n" +
            " where id =:id ", nativeQuery = true)
    int updateAddAccountAmountAndAccountAvailableAmountById(Long id, BigDecimal amount);

    @Modifying
    @Query(value = "update account set account_amount = account_amount - :amount,account_available_amount = account_available_amount - :amount\n" +
            " where id =:id ", nativeQuery = true)
    int updateSubtractAccountAmountAndAccountAvailableAmountById(Long id, BigDecimal amount);

    @Modifying
    @Query(value = "update account set account_occupancy_amount = account_occupancy_amount - :amount,account_available_amount = account_available_amount + :amount\n" +
            " where id =:id ", nativeQuery = true)
    int updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(Long id, BigDecimal amount);

    // 通过账户主体编码更新账户主体名称，
    @Transactional
    @Modifying
    @Query(value = "update account set account_holder_name = :accountHolderName,account_name = :accountName where account_holder_code = :accountHolderCode and account_type = :accountType ", nativeQuery = true)
    void updateAccountHolderNameByAccountHolderCode(String accountHolderName, String accountName, String accountHolderCode, String accountType);

}
