package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_acc_eng_det_condition")
@org.hibernate.annotations.Table(appliesTo = "fin_acc_eng_det_condition", comment = "会计引擎条件")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccEngDetConditionDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "serial_num", columnDefinition = "int(6) comment '序列号'")
    private Integer serialNum;

    @Column(name = "table_name", columnDefinition = "varchar(20) comment '表单名称'")
    private String tableName;

    @Column(name = "column_name", columnDefinition = "varchar(32) comment '字段名称'")
    private String columnName;

    @Column(name = "condition_type", columnDefinition = "varchar(20) comment '条件'")
    private String conditionType;

    @Column(name = "value_from", columnDefinition = "varchar(20) comment '从值内容'")
    private String valueFrom;

    @Column(name = "value_to", columnDefinition = "varchar(20) comment '至值内容'")
    private String valueTo;
}
