package com.elitesland.fin.utils.excel.convert.annotation;

import com.elitesland.fin.utils.excel.convert.Converter;
import com.elitesland.fin.application.facade.excel.convert.DefaultConverter;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelConvert {
    /**
     * if set value(not equal "" and not null), will set this `value` to field
     */
    String value() default "";
    
    Class<? extends Converter> converter() default DefaultConverter.class;
    
    /**
     * This field will receive which name of field of source object.
     * This name default "", and field will receive same name of field of source
     *  when name equal "".
     */
    String name() default "";
    
    Class[] scope() default {Class.class};
}
