/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccountPeriodLineConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountPeriodDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountPeriodLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountPeriodParam;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinAccountPeriodLineDO;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodRepo;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FinAccountPeriodRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final FinAccountPeriodRepo finAccountPeriodRepo;
    private final FinAccountPeriodLineRepo finAccountPeriodLineRepo;
    private final QFinAccountPeriodDO qFinAccountPeriodDO = QFinAccountPeriodDO.finAccountPeriodDO;
    private final QFinAccountPeriodLineDO qFinAccountPeriodLineDO = QFinAccountPeriodLineDO.finAccountPeriodLineDO;

    public PagingVO<FinAccountPeriodDTO> page(FinAccountPeriodParam finAccountPeriodParam) {
        Predicate where = this.where(finAccountPeriodParam);
        JPAQuery query = (JPAQuery)this.select(FinAccountPeriodDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        finAccountPeriodParam.setPaging(query);
        finAccountPeriodParam.fillOrders(query, this.qFinAccountPeriodDO);
        List finAccountPeriodDTOList = query.fetch();
        List<Long> ids = finAccountPeriodDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        List<FinAccountPeriodLineDTO> finAccountPeriodLineDTOList = FinAccountPeriodLineConvert.INSTANCE.DOToDTO(this.finAccountPeriodLineRepo.findAllByMasIdIn(ids));
        for (FinAccountPeriodDTO finAccountPeriodDTO : finAccountPeriodDTOList) {
            finAccountPeriodDTO.setDetailList(finAccountPeriodLineDTOList.stream().filter(finFlexibleValueDO -> finAccountPeriodDTO.getId().equals(finFlexibleValueDO.getMasId())).collect(Collectors.toList()));
        }
        return PagingVO.builder().total((long)finAccountPeriodDTOList.size()).records(finAccountPeriodDTOList).build();
    }

    private Predicate where(FinAccountPeriodParam finAccountPeriodParam) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(finAccountPeriodParam.getId() != null, this.qFinAccountPeriodDO.id, (Object)finAccountPeriodParam.getId()).andIn(CollectionUtil.isNotEmpty(finAccountPeriodParam.getAccountPeriodCodeList()), (SimpleExpression)this.qFinAccountPeriodDO.accountPeriodCode, finAccountPeriodParam.getAccountPeriodCodeList()).andLike(StringUtils.isNotEmpty((CharSequence)finAccountPeriodParam.getAccountPeriodCode()), (StringExpression)this.qFinAccountPeriodDO.accountPeriodCode, StringUtil.buildLikeString(finAccountPeriodParam.getAccountPeriodCode())).andLike(StringUtils.isNotEmpty((CharSequence)finAccountPeriodParam.getAccountPeriodName()), (StringExpression)this.qFinAccountPeriodDO.accountPeriodName, StringUtil.buildLikeString(finAccountPeriodParam.getAccountPeriodName())).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFinAccountPeriodDO.id, this.qFinAccountPeriodDO.accountPeriodCode, this.qFinAccountPeriodDO.accountPeriodName, this.qFinAccountPeriodDO.status, this.qFinAccountPeriodDO.createTime, this.qFinAccountPeriodDO.creator, this.qFinAccountPeriodDO.modifyTime, this.qFinAccountPeriodDO.updater})).from((EntityPath)this.qFinAccountPeriodDO);
    }

    public FinAccountPeriodDO findByAccountPeriodCode(String accountPeriodCode) {
        List<FinAccountPeriodDO> finAccountPeriodDOList = this.finAccountPeriodRepo.findAllByAccountPeriodCode(accountPeriodCode);
        if (CollectionUtils.isNotEmpty(finAccountPeriodDOList)) {
            Assert.equals((Object)finAccountPeriodDOList.size(), (Object)1, (String)"\u67e5\u8be2\u5230\u591a\u6761\u4f1a\u8ba1\u671f\u95f4", (Object[])new Object[0]);
            return finAccountPeriodDOList.get(0);
        }
        return null;
    }

    public List<FinAccountPeriodDTO> findByParam(FinAccountPeriodParam finAccountPeriodParam) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(FinAccountPeriodDTO.class, (Expression[])new Expression[]{this.qFinAccountPeriodDO.id, this.qFinAccountPeriodDO.accountPeriodCode, this.qFinAccountPeriodDO.accountPeriodName, this.qFinAccountPeriodDO.status, this.qFinAccountPeriodDO.createTime, this.qFinAccountPeriodDO.creator, this.qFinAccountPeriodDO.modifyTime, this.qFinAccountPeriodDO.updater, this.qFinAccountPeriodLineDO.periodStyle})).from((EntityPath)this.qFinAccountPeriodDO)).innerJoin((EntityPath)this.qFinAccountPeriodLineDO)).on((Predicate)this.qFinAccountPeriodDO.id.eq(this.qFinAccountPeriodLineDO.masId));
        jpaQuery.where(ExpressionUtils.allOf((Predicate[])new Predicate[]{this.where(finAccountPeriodParam), this.whereDetails(finAccountPeriodParam)}));
        return jpaQuery.fetch();
    }

    private Predicate whereDetails(FinAccountPeriodParam finAccountPeriodParam) {
        return BaseRepoProc.PredicateBuilder.builder().andIn(CollectionUtil.isNotEmpty(finAccountPeriodParam.getPeriodStyleList()), (SimpleExpression)this.qFinAccountPeriodLineDO.periodStyle, finAccountPeriodParam.getPeriodStyleList()).andBefore(ObjectUtil.isNotNull((Object)finAccountPeriodParam.getTransactionDate()), this.qFinAccountPeriodLineDO.activeStartTime, (Comparable)finAccountPeriodParam.getTransactionDate()).andAfter(ObjectUtil.isNotNull((Object)finAccountPeriodParam.getTransactionDate()), this.qFinAccountPeriodLineDO.activeEndTime, (Comparable)finAccountPeriodParam.getTransactionDate()).build();
    }

    public FinAccountPeriodRepoProc(JPAQueryFactory jpaQueryFactory, FinAccountPeriodRepo finAccountPeriodRepo, FinAccountPeriodLineRepo finAccountPeriodLineRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.finAccountPeriodRepo = finAccountPeriodRepo;
        this.finAccountPeriodLineRepo = finAccountPeriodLineRepo;
    }
}

