package com.elitesland.fin.common;

/**
 * @Author: ryan.xu
 * @since 2023/4/6
 */
public enum FosUdcEnum {

    COM_APPLY_STATUS_DRAFT("COM", "APPLY_STATUS", "状态", "DRAFT", "草稿"),

    FRANCHISEE_APPLY_STATUS_DR("FOS", "FRANCHISEE_APPLY_STATUS_DR", "加盟商申请状态", "DR", "草稿"),
    FRANCHISEE_APPLY_STATUS_APPROVING("FOS", "FRANCHISEE_APPLY_STATUS_APPROVING", "加盟商申请状态", "APPROVING", "审批中"),
    FRANCHISEE_APPLY_STATUS_AGREE("FOS", "FRANCHISEE_APPLY_STATUS_AGREE", "加盟商意向申请状态", "AGREE", "同意"),

    FRANCHISEE_APPLY_STATUS_DONE("FOS", "FRANCHISEE_APPLY_STATUS_DONE", "加盟商意向申请状态", "DONE", "已完成"),
    FRANCHISEE_APPLY_STATUS_SIGNDONE("FOS", "FRANCHISEE_APPLY_STATUS_SIGNDONE", "加盟商意向申请状态", "SIGNDONE", "意向书签章完成"),
    FRANCHISEE_APPLY_STATUS_REJECTD("FOS", "FRANCHISEE_APPLY_STATUS_REJECT", "加盟商意向申请状态", "REJECTED", "审批拒绝"),
    FRANCHISEE_APPLY_STATUS_INVALID("FOS", "FRANCHISEE_APPLY_STATUS_INVALID", "加盟商意向申请状态", "INVALID", "作废"),
    FRANCHISEE_APPLY_STATUS_EFECT("FOS", "FRANCHISEE_APPLY_STATUS_EFECT", "加盟商意向申请状态", "ECECT", "中断执行"),
    FRANCHISEE_STATUS_VALID("FOS", "FRANCHISEE_STATUS", "加盟商档案状态", "VALID", "正式加盟商"),
    FRANCHISEE_STATUS_INVALID("FOS", "FRANCHISEE_STATUS", "加盟商档案状态", "INVALID", "停用"),
    FRANCHISEE_STATUS_DR("FOS", "FRANCHISEE_STATUS", "加盟商档案状态", "DR", "草稿"),
    FRANCHISEE_STATUS_NRC("FOS", "FRANCHISEE_STATUS", "加盟商档案状态", "NRC", "未背调"),
    FRANCHISEE_STATUS_RE("FOS", "FRANCHISEE_STATUS", "加盟商档案状态", "RE", "资源加盟商"),

    FRANCHISEE_REFER_CHECK_STATUS_DR("FOS", "FRANCHISEE_REFER_CHECK_STATUS", "加盟商背调申请状态", "DR", "草稿"),
    FRANCHISEE_REFER_CHECK_STATUS_APPROVING("FOS", "FRANCHISEE_REFER_CHECK_STATUS", "加盟商背调申请状态", "APPROVING", "审批中"),
    FRANCHISEE_REFER_CHECK_STATUS_REJECTED("FOS", "FRANCHISEE_REFER_CHECK_STATUS", "加盟商背调申请状态", "REJECTED", "审批拒绝"),
    FRANCHISEE_REFER_CHECK_STATUS_DONE("FOS", "FRANCHISEE_REFER_CHECK_STATUS", "加盟商背调申请状态", "DONE", "已完成"),
    FRANCHISEE_REFER_CHECK_STATUS_INVALID("FOS", "FRANCHISEE_REFER_CHECK_STATUS", "加盟商背调申请状态", "INVALID", "作废"),

    FRANCHISEE_REGISTER_STATUS_REGISTERED("FOS", "FRANCHISEE_REGISTER_STATUS", "加盟商注册状态", "REGISTERED", "已注册"),
    FRANCHISEE_REGISTER_STATUS_APPROVED("FOS", "FRANCHISEE_REGISTER_STATUS", "加盟商注册状态", "APPROVED", "已加盟"),
    FRANCHISEE_REGISTER_STATUS_APPROVING("FOS", "FRANCHISEE_REGISTER_STATUS", "加盟商注册状态", "APPROVING", "加盟中"),

    INTENTMODEL_ENABLE_STATUS_YES("FOS", "INTENTMODEL_ENABLE_STATUS_YES", "意向书模板启用状态", "1", "是"),
    INTENTMODEL_ENABLE_STATUS_NO("FOS", "INTENTMODEL_ENABLE_STATUS_NO", "意向书模板启用状态", "0", "否"),

    RC_TYPE_ID_CARD_FRONT("FOS", "RC_TYPE", "背调资料类型", "ID_CARD_FRONT", "身份证正面"),
    RC_TYPE_ID_CARD_BACK("FOS", "RC_TYPE", "背调资料类型", "ID_CARD_BACK", "身份证反面"),

    PAYMENT_RECORDS_STATUS_CONFIRM("FOS", "PAYMENT_STATUS", "付款状态", "CONFIRM", "财务确认"),
    PAYMENT_RECORDS_STATUS_YFK("FOS", "PAYMENT_STATUS", "付款状态", "YFK", "已付款"),
    PAYMENT_RECORDS_STATUS_DPAYMENT("FOS", "PAYMENT_STATUS", "付款状态", "DPAYMENT", "待付款"),

    //合同类型
    CONTRACT_TYPE_FRANCHISE("FOS", "CONTRACT_TYPE", "合同类型", "FRANCHISE", "特许经营合同"),
    CONTRACT_TYPE_KA("FOS", "CONTRACT_TYPE", "合同类型", "KA", "KA加盟"),
    CONTRACT_TYPE_GREEN_TOWN("FOS", "CONTRACT_TYPE", "合同类型", "GREEN_TOWN", "绿城"),
    CONTRACT_TYPE_CUSTOM("FOS", "CONTRACT_TYPE", "合同类型", "CUSTOM", "自定义维护"),
    //合同状态,
    CONTRACT_STATUS_DRAFT("FOS", "CONTRACT_STATUS", "合同状态", "DRAFT", "草稿"),
    CONTRACT_STATUS_UN_EFFECT("FOS", "CONTRACT_STATUS", "合同状态", "UN_EFFECT", "未生效"),
    CONTRACT_STATUS_EFFECT("FOS", "CONTRACT_STATUS", "合同状态", "EFFECT", "已生效"),
    CONTRACT_STATUS_INVALID("FOS", "CONTRACT_STATUS", "合同状态", "INVALID", "已作废"),
    //合同附件类型
    CONTRACT_FILE_TYPE_INITIAL("FOS", "CONTRACT_FILE_TYPE", "合同附件类型", "INITIAL", "初始合同"),
    CONTRACT_FILE_TYPE_FINALLY("FOS", "CONTRACT_FILE_TYPE", "合同附件类型", "FINALLY", "最终合同"),


    FLOWNODE_OA_STATUS("FOS", "FLOWNODE_OA_STATUS", "OA审批", "P001-4", "发起审批"),
    FLOWNODE_FRANCHISEETWO_STATUS("FOS", "FLOWNODE_FRANCHISEETWO_STATUS", "加盟部二级审", "P001-3", ""),
    FLOWNODE_FRANCHISEEONE_STATUS("FOS", "FLOWNODE_FRANCHISEEONE_STATUS", "加盟部一级审", "P001-2", ""),

    //渠道
    CHANNEL_TYPE_KA("FOS", "CHANNEL_TYPE", "渠道类型", "KA", "KA加盟"),
    CHANNEL_TYPE_CT("FOS", "CHANNEL_TYPE", "渠道类型", "CT", "传统加盟"),

    ;

    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    FosUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }
}
