package com.elitesland.fin.utils;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.system.dto.resp.ImportResultRespVO;
import com.elitesland.fin.common.FinConstant;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public class ExcelUtil {
    private ExcelUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ImportResultRespVO.SyncResult getSyncResult(List<String> errorResult, ImportResultRespVO.SyncResult syncResult, int size) {
        syncResult.setTotal(size);
        List<String> failRecords = syncResult.getFailRecords();
        if (CollectionUtils.isNotEmpty(failRecords)){
            failRecords.addAll(errorResult);
            syncResult.setFailRecords(failRecords);
        } else {
            syncResult.setFailRecords(errorResult);
        }
        return syncResult;
    }

    public static String twoPointNum(BigDecimal num) {

        if (ObjectUtil.isNull(num)) {
            return FinConstant.BLANK;
        }
        DecimalFormat decimalFormat = new DecimalFormat(FinConstant.TWO_POINT);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        String format = decimalFormat.format(num);
        return format;
    }
}
