/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountSnapshotVo;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.excel.entity.CreditAccountSnapshotExportEntity;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreditAccountSnapshotExportServiceImpl
implements DataExport<CreditAccountSnapshotExportEntity, CreditAccountSnapshotParam> {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountSnapshotExportServiceImpl.class);
    private final CreditAccountService creditAccountService;

    public String getTmplCode() {
        return "credit_account_snapshot_export";
    }

    @BusinessObjectOperation(permissionRef="fin_credit_account_snapshot_list", businessObjectType="Fin_Credit_Account:\u4fe1\u7528\u8d26\u6237", operationType=OperationTypeEnum.EXPORT, operationDescription="\u4fe1\u7528\u8d26\u6237\u5feb\u7167\u5bfc\u51fa", operationCode="fin_credit_account_snapshot_export", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<CreditAccountSnapshotExportEntity> executeExport(CreditAccountSnapshotParam queryParam) {
        PagingVO<CreditAccountSnapshotVo> pagingVO = this.creditAccountService.querySnapshot(queryParam);
        return new PagingVO(pagingVO.getTotal(), ExcelConvertUtils.convertLoosely(pagingVO.getRecords(), CreditAccountSnapshotExportEntity.class));
    }

    public CreditAccountSnapshotExportServiceImpl(CreditAccountService creditAccountService) {
        this.creditAccountService = creditAccountService;
    }
}

