/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.aporder.ApOrderDtlGroupSaveParam;
import com.elitesland.fin.application.facade.param.aporder.ApOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aptype.ApTypeVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.aptype.ApTypeService;
import com.elitesland.fin.application.service.workflow.arorder.ArOrderProcessService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderProcessServiceImpl
implements ArOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(ArOrderProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderRepo arOrderRepo;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final TaskExecutor taskExecutor;
    private final ArOrderDomainService arOrderDomainService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderRepo apOrderRepo;
    private final ApOrderService apOrderService;
    private final ApTypeService apTypeService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final PurSuppOutService purSuppOutService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(List.of(Long.valueOf(id)));
        if (arOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QArOrderDO qRecOrderDO = QArOrderDO.arOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qRecOrderDO).set(qRecOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qRecOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)qRecOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(qRecOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(qRecOrderDO.approvedTime, (Object)LocalDateTime.now()).set(qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set(qRecOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)qRecOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)qRecOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(qRecOrderDO.approvedTime, (Object)LocalDateTime.now()).set(qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set(qRecOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)qRecOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)qRecOrderDO.procInstId, (Object)null).set((Path)qRecOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)qRecOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)qRecOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(qRecOrderDO.approvedTime, (Object)LocalDateTime.now()).set(qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set(qRecOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)qRecOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            if ("OUT".equals(arOrderDTO.getInOutCust()) && "MANU".equals(arOrderDTO.getCreateMode())) {
                arOrderDTO.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
                this.arOrderDomainService.createFinFlow(arOrderDTO);
            }
            String custType2 = this.getCustType2(arOrderDTO);
            List<ApOrderDO> data = this.apOrderRepoProc.queryBySourceNo(arOrderDTO.getArOrderNo());
            if ("C".equals(custType2) && "MANU".equalsIgnoreCase(arOrderDTO.getCreateMode()) && CollUtil.isEmpty(data)) {
                ApOrderSaveParam apOrderSaveParam = this.getApOrderSaveParam(arOrderDTO, arOrderDtlDTOS);
                this.apOrderService.save(apOrderSaveParam);
            }
            CompletableFuture.runAsync(() -> {
                log.info("\u5e94\u6536\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
                this.finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
                this.updateVerState(id);
            }, (Executor)this.taskExecutor);
        }
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        List apTypeVOList = (List)this.apTypeService.getList().computeData();
        Optional<ApTypeVO> first = apTypeVOList.stream().filter(e -> e.getApTypeCode().equals(code)).findFirst();
        return first.map(ApTypeVO::getId).orElse(null);
    }

    private ApOrderSaveParam getApOrderSaveParam(ArOrderDTO arOrderDTO, List<ArOrderDtlDTO> arOrderDtlDTOS) {
        List<ApOrderDO> apOrderDOS;
        log.info("\u751f\u6210\u5e94\u4ed8\u5355\u5165\u53c2:arOrderDTO:{},recOrderDtlDTOS:{}", (Object)JSONUtil.toJsonStr((Object)arOrderDTO), (Object)JSONUtil.toJsonStr(arOrderDtlDTOS));
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Arrays.asList(arOrderDTO.getCustCode()));
        List<CustBaseDTO> baseCustByParam = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new BusinessException("\u5e94\u6536\u5355\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)custBaseDTO));
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u7f16\u7801:{}", (Object)corBusinCode);
        if (StrUtil.isBlank((CharSequence)corBusinCode)) {
            throw new BusinessException("\u5e94\u6536\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new BusinessException("\u5e94\u6536\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)orgOuRpcSimpleDTO));
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setOuCode2s(Arrays.asList(arOrderDTO.getOuCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = this.purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new BusinessException("\u5e94\u6536\u5355\u516c\u53f8\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        ApOrderSaveParam param = new ApOrderSaveParam();
        param.setTaxFlag(true);
        param.setInOutCust(purSuppBaseRpcDTO.getIoType());
        param.setCurrCode(StrUtil.isNotBlank((CharSequence)arOrderDTO.getCurrCode()) ? arOrderDTO.getCurrCode() : "CNY");
        param.setCurrName(StrUtil.isNotBlank((CharSequence)arOrderDTO.getCurrName()) ? arOrderDTO.getCurrName() : "\u4eba\u6c11\u5e01");
        param.setLocalCurrCode(StrUtil.isNotBlank((CharSequence)arOrderDTO.getLocalCurrCode()) ? arOrderDTO.getLocalCurrCode() : "CNY");
        param.setLocalCurrName(StrUtil.isNotBlank((CharSequence)arOrderDTO.getLocalCurrName()) ? arOrderDTO.getLocalCurrName() : "\u4eba\u6c11\u5e01");
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        param.setSuppId(purSuppBaseRpcDTO.getId());
        param.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        param.setSuppName(purSuppBaseRpcDTO.getSuppName());
        param.setSourceNo(arOrderDTO.getArOrderNo());
        param.setApTypeCode("YFD01_SYS");
        param.setApTypeName("\u6807\u51c6\u5e94\u4ed8\u5355");
        param.setApTypeId(this.getApTypeIdByCode("YFD01_SYS"));
        param.setCreateMode("AR");
        param.setBuDate(arOrderDTO.getBuDate());
        param.setRelevanceOuCode(arOrderDTO.getOuCode());
        param.setProtocolCode(arOrderDTO.getProtocolCode());
        param.setExchangeRate(arOrderDTO.getExchangeRate());
        param.setTotalAmt(arOrderDTO.getTotalAmt());
        param.setTotalCurAmt(arOrderDTO.getTotalCurAmt());
        param.setExclTaxAmt(arOrderDTO.getExclTaxAmt());
        param.setExclTaxCurAmt(arOrderDTO.getExclTaxCurAmt());
        param.setTaxAmt(arOrderDTO.getTaxAmt());
        param.setTaxCurAmt(arOrderDTO.getTaxCurAmt());
        param.setInitFlag(arOrderDTO.getInitFlag());
        param.setExchangeRate(arOrderDTO.getExchangeRate());
        param.setOrderState("COMPLETE");
        param.setRedState(arOrderDTO.getRedState());
        String redSourceNo = arOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank((CharSequence)redSourceNo) && CollUtil.isNotEmpty(apOrderDOS = this.apOrderRepoProc.queryBySourceNo(redSourceNo))) {
            ApOrderDO apOrderDO = apOrderDOS.get(0);
            param.setRedSourceNo(apOrderDO.getApOrderNo());
            param.setRedSourceId(apOrderDO.getId());
            apOrderDO.setRedState(true);
            this.apOrderRepo.saveAndFlush(apOrderDO);
        }
        param.setProposedStatus("DRAFT");
        List<ApOrderDtlSaveParam> apOrderDtlSaveParams = arOrderDtlDTOS.stream().map(arOrderDtlDTO -> {
            ApOrderDtlSaveParam dtlSaveParam = new ApOrderDtlSaveParam();
            dtlSaveParam.setProtocolCode(arOrderDTO.getProtocolCode());
            dtlSaveParam.setSourceNo(arOrderDtlDTO.getSourceNo());
            dtlSaveParam.setSourceLine(arOrderDtlDTO.getSourceLine());
            dtlSaveParam.setItemId(arOrderDtlDTO.getItemId());
            dtlSaveParam.setItemCode(arOrderDtlDTO.getItemCode());
            dtlSaveParam.setItemName(arOrderDtlDTO.getItemName());
            dtlSaveParam.setItemType(arOrderDtlDTO.getItemType());
            dtlSaveParam.setSmallCateCode(arOrderDtlDTO.getSmallCateCode());
            dtlSaveParam.setSmallCateName(arOrderDtlDTO.getSmallCateName());
            dtlSaveParam.setUom(arOrderDtlDTO.getUom());
            dtlSaveParam.setUomName(arOrderDtlDTO.getUomName());
            dtlSaveParam.setQty(arOrderDtlDTO.getQty());
            dtlSaveParam.setExclTaxPrice(arOrderDtlDTO.getExclTaxPrice());
            dtlSaveParam.setPrice(arOrderDtlDTO.getPrice());
            dtlSaveParam.setTaxRate(arOrderDtlDTO.getTaxRate());
            dtlSaveParam.setTotalAmt(arOrderDtlDTO.getTotalAmt());
            dtlSaveParam.setTotalCurAmt(arOrderDtlDTO.getTotalCurAmt());
            dtlSaveParam.setExclTaxAmt(arOrderDtlDTO.getExclTaxAmt());
            dtlSaveParam.setExclTaxCurAmt(arOrderDtlDTO.getExclTaxCurAmt());
            dtlSaveParam.setTaxAmt(arOrderDtlDTO.getTaxAmt());
            dtlSaveParam.setTaxCurAmt(arOrderDtlDTO.getTaxCurAmt());
            dtlSaveParam.setVerAmt(BigDecimal.ZERO);
            dtlSaveParam.setUnVerAmt(arOrderDTO.getTotalAmt());
            dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
            return dtlSaveParam;
        }).collect(Collectors.toList());
        param.setApOrderDtlSaveParamList(apOrderDtlSaveParams);
        Map<String, List<ApOrderDtlSaveParam>> groupedByItemCode = apOrderDtlSaveParams.stream().collect(Collectors.groupingBy(ApOrderDtlSaveParam::getItemCode));
        List<ApOrderDtlGroupSaveParam> orderDtlGroupSaveParams = groupedByItemCode.entrySet().stream().map(entry -> {
            ApOrderDtlGroupSaveParam apOrderDtlGroupSaveParam = new ApOrderDtlGroupSaveParam();
            apOrderDtlGroupSaveParam.setItemCode((String)entry.getKey());
            List value = (List)entry.getValue();
            ApOrderDtlSaveParam first = (ApOrderDtlSaveParam)value.get(0);
            apOrderDtlGroupSaveParam.setItemId(first.getItemId());
            apOrderDtlGroupSaveParam.setItemName(first.getItemName());
            apOrderDtlGroupSaveParam.setSmallCateCode(first.getSmallCateCode());
            apOrderDtlGroupSaveParam.setSmallCateName(first.getSmallCateName());
            apOrderDtlGroupSaveParam.setQty(value.stream().map(ApOrderDtlSaveParam::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
            apOrderDtlGroupSaveParam.setTotalAmt(value.stream().map(ApOrderDtlSaveParam::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            apOrderDtlGroupSaveParam.setTotalCurAmt(value.stream().map(ApOrderDtlSaveParam::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            apOrderDtlGroupSaveParam.setExclTaxAmt(value.stream().map(ApOrderDtlSaveParam::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            apOrderDtlGroupSaveParam.setExclTaxCurAmt(value.stream().map(ApOrderDtlSaveParam::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            apOrderDtlGroupSaveParam.setTaxAmt(value.stream().map(ApOrderDtlSaveParam::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            apOrderDtlGroupSaveParam.setTaxCurAmt(value.stream().map(ApOrderDtlSaveParam::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            return apOrderDtlGroupSaveParam;
        }).collect(Collectors.toList());
        param.setApOrderDtlGroupSaveParamList(orderDtlGroupSaveParams);
        log.info("\u751f\u6210\u5e94\u4ed8\u5355\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    private String getCustType2(ArOrderDTO arOrderDTO) {
        List<CrmCustBaseDTO> custBaseInfoList = this.rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(arOrderDTO.getCustCode()));
        if (CollUtil.isEmpty(custBaseInfoList)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801" + arOrderDTO.getCustCode() + "\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CrmCustBaseDTO crmCustBaseDTO = custBaseInfoList.get(0);
        return crmCustBaseDTO.getCustType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(businessId);
        if (arOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(arOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    private void updateVerState(Long id) {
        ArOrderDTO newArOrderDTO = this.arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> newArOrderDtlDTOList = this.arOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;
        BigDecimal verAmtingSum = BigDecimal.ZERO;
        BigDecimal unVerAmtSum = BigDecimal.ZERO;
        if (CollUtil.isNotEmpty(newArOrderDtlDTOList)) {
            for (ArOrderDtlDTO arOrderDtlDTO : newArOrderDtlDTOList) {
                if (null != arOrderDtlDTO.getVerAmt()) {
                    verAmtSum = verAmtSum.add(arOrderDtlDTO.getVerAmt());
                }
                if (arOrderDtlDTO.getApplyVerAmTing() != null) {
                    verAmtingSum = verAmtingSum.add(arOrderDtlDTO.getApplyVerAmTing());
                }
                if (arOrderDtlDTO.getUnVerAmt() == null) continue;
                unVerAmtSum = unVerAmtSum.add(arOrderDtlDTO.getUnVerAmt());
            }
        }
        String verState = null;
        verState = unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0 ? UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode() : (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newArOrderDTO.getTotalAmt()) == 0 ? UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode() : UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)verState)) {
            this.arOrderRepoProc.updateVerState(verState, id);
        }
    }

    public ArOrderProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, ArOrderRepoProc arOrderRepoProc, ArOrderRepo arOrderRepo, ArOrderDtlRepoProc arOrderDtlRepoProc, JPAQueryFactory jpaQueryFactory, FinArRecVerApplyService finArRecVerApplyService, TaskExecutor taskExecutor, ArOrderDomainService arOrderDomainService, RmiSaleRpcService rmiSaleRpcService, ApOrderRepoProc apOrderRepoProc, ApOrderRepo apOrderRepo, ApOrderService apOrderService, ApTypeService apTypeService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, PurSuppOutService purSuppOutService) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.arOrderRepoProc = arOrderRepoProc;
        this.arOrderRepo = arOrderRepo;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.finArRecVerApplyService = finArRecVerApplyService;
        this.taskExecutor = taskExecutor;
        this.arOrderDomainService = arOrderDomainService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderRepo = apOrderRepo;
        this.apOrderService = apOrderService;
        this.apTypeService = apTypeService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.purSuppOutService = purSuppOutService;
    }
}

