/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.saleinvd;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.domain.service.saleinvd.SaleInvdDomainService;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvdDomainServiceImpl
implements SaleInvdDomainService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvdDomainServiceImpl.class);
    public final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    public final SaleInvdDtlRepo saleInvdDtlRepo;
    public final InvoiceRuleConfigDomainService invoiceRuleConfigDomainService;
    public final InvoiceRedraftRepo invoiceRedraftRepo;
    public final InvoiceRedraftRepoProc invoiceRedraftRepoProc;
    public final SaleInvRepo saleInvRepo;
    private final InvoiceAwaitService invoiceAwaitService;
    private final InvoiceService invoiceService;

    @Override
    @Transactional
    public void cancel(Long id) {
        Assert.notNull((Object)id, (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        SaleInvdDtlDO saleInvdDtlDO = this.querySaleInvdDtlDOById(id);
        Assert.equals((Object)saleInvdDtlDO.getInvState(), (Object)UdcEnum.INV_STATE_SUCCESS.getValueCode(), (String)"\u53ea\u6709\u5f00\u7968\u72b6\u6001\u4e3a\u5f00\u7968\u6210\u529f\u624d\u80fd\u4f5c\u5e9f", (Object[])new Object[0]);
        Assert.equals((Object)saleInvdDtlDO.getRedState(), (Object)UdcEnum.RED_STATE_NO.getValueCode(), (String)"\u53ea\u6709\u7ea2\u51b2\u72b6\u6001\u4e3a\u672a\u7ea2\u51b2\u624d\u80fd\u4f5c\u5e9f", (Object[])new Object[0]);
        saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_CANCEL_SUCCESS.getValueCode());
    }

    @Override
    @Transactional
    public void red(Long id) {
        String redFailCause;
        Assert.notNull((Object)id, (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        SaleInvdDtlDO saleInvdDtlDO = this.querySaleInvdDtlDOById(id);
        Assert.equals((Object)saleInvdDtlDO.getInvState(), (Object)UdcEnum.INV_STATE_SUCCESS.getValueCode(), (String)"\u53ea\u6709\u5f00\u7968\u72b6\u6001\u4e3a\u5f00\u7968\u6210\u529f\u624d\u80fd\u7ea2\u51b2", (Object[])new Object[0]);
        Assert.equals((Object)saleInvdDtlDO.getRedState(), (Object)UdcEnum.RED_STATE_NO.getValueCode(), (String)"\u53ea\u6709\u7ea2\u51b2\u72b6\u6001\u4e3a\u672a\u7ea2\u51b2\u624d\u80fd\u7ea2\u51b2", (Object[])new Object[0]);
        ArrayList<InvoiceRuleConfigQueryParam> invoiceRuleConfigQueryParamList = new ArrayList<InvoiceRuleConfigQueryParam>();
        InvoiceRuleConfigQueryParam invoiceRuleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        SaleInvDO saleInvDO = this.querySaleInvDOById(saleInvdDtlDO.getMasId());
        invoiceRuleConfigQueryParam.setOptDocCls(saleInvDO.getCreateMode());
        invoiceRuleConfigQueryParamList.add(invoiceRuleConfigQueryParam);
        List<InvoiceRuleConfigDTO> invoiceRuleConfigDTOList = this.invoiceRuleConfigDomainService.getRuleConfigList(invoiceRuleConfigQueryParamList);
        InvoiceRedApplySaveParam saveParam = new InvoiceRedApplySaveParam();
        saveParam.setOriginApplyNo(saleInvDO.getApplyNo());
        saveParam.setSaleTaxNo(saleInvDO.getSaleTaxNo());
        saveParam.setCustTaxNo(saleInvDO.getCustTaxNo());
        saveParam.setInvType(saleInvDO.getInvType());
        saveParam.setInvDate(saleInvdDtlDO.getInvDate());
        saveParam.setInvNo(saleInvdDtlDO.getInvNo());
        try {
            redFailCause = this.invoiceService.redInvoice(saveParam);
        }
        catch (Exception e) {
            log.error("\u7ea2\u7968\u7533\u8bf7\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            redFailCause = e.getMessage();
        }
        if (redFailCause == null) {
            saleInvdDtlDO.setRedState(UdcEnum.RED_STATE_SUCCESS.getValueCode());
            saleInvdDtlDO.setRedFailCause(null);
            this.saleInvdDtlRepoProc.updateRedState(saleInvdDtlDO);
            SaleInvStatusParam statusParam = new SaleInvStatusParam();
            statusParam.setApplyNo(saleInvDO.getApplyNo());
            statusParam.setInvState(UdcEnum.RED_STATE_SUCCESS.getValueCode());
            this.invoiceAwaitService.updateRedState(statusParam);
            saleInvdDtlDO.setInvoiceRedraftState(null);
        } else {
            saleInvdDtlDO.setRedState(UdcEnum.RED_STATE_FAIL.getValueCode());
            saleInvdDtlDO.setRedFailCause(redFailCause);
        }
    }

    @Override
    public InvoiceRedraftPageVO redraft(Long id) {
        Assert.notNull((Object)id, (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        SaleInvdDtlDO saleInvdDtlDO = this.querySaleInvdDtlDOById(id);
        Assert.equals((Object)saleInvdDtlDO.getInvState(), (Object)UdcEnum.INV_STATE_SUCCESS.getValueCode(), (String)"\u53ea\u6709\u5f00\u7968\u72b6\u6001\u4e3a\u5f00\u7968\u6210\u529f\u624d\u80fd\u6362\u5f00\u7533\u8bf7", (Object[])new Object[0]);
        Assert.equals((Object)saleInvdDtlDO.getRedState(), (Object)UdcEnum.RED_STATE_NO.getValueCode(), (String)"\u53ea\u6709\u7ea2\u51b2\u72b6\u6001\u4e3a\u672a\u7ea2\u51b2\u624d\u80fd\u6362\u5f00\u7533\u8bf7", (Object[])new Object[0]);
        ArrayList<InvoiceRuleConfigQueryParam> invoiceRuleConfigQueryParamList = new ArrayList<InvoiceRuleConfigQueryParam>();
        InvoiceRuleConfigQueryParam invoiceRuleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        SaleInvDO saleInvDO = this.querySaleInvDOById(saleInvdDtlDO.getMasId());
        invoiceRuleConfigQueryParam.setOptDocCls(saleInvDO.getCreateMode());
        invoiceRuleConfigQueryParamList.add(invoiceRuleConfigQueryParam);
        List<InvoiceRuleConfigDTO> invoiceRuleConfigDTOList = this.invoiceRuleConfigDomainService.getRuleConfigList(invoiceRuleConfigQueryParamList);
        Assert.notEmpty(invoiceRuleConfigDTOList, (String)"\u6765\u6e90\u5355\u636e\u5339\u914d\u4e0d\u5230\u5f00\u7968\u8bbe\u7f6e", (Object[])new Object[0]);
        boolean flag = true;
        for (InvoiceRuleConfigDTO invoiceRuleConfigDTO : invoiceRuleConfigDTOList) {
            if (invoiceRuleConfigDTO.getNeedRedraft() != 0) continue;
            flag = false;
            break;
        }
        Assert.isTrue((boolean)flag, (String)"\u6765\u6e90\u5355\u636e\u65e0\u9700\u63d0\u4ea4\u6362\u5f00\u7533\u8bf7", (Object[])new Object[0]);
        if (UdcEnum.APPLY_STATUS_DOING.getValueCode().equals(saleInvdDtlDO.getInvoiceRedraftState())) {
            throw new BusinessException("\u6362\u5f00\u7533\u8bf7\u5ba1\u6279\u4e2d");
        }
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(saleInvdDtlDO.getInvoiceRedraftState())) {
            throw new BusinessException("\u6362\u5f00\u7533\u8bf7\u5df2\u5ba1\u6279\u901a\u8fc7");
        }
        SaleInvDTO saleInvDTO = SaleInvConvert.INSTANCE.saleInvDO2SaleInvDTO(saleInvDO);
        InvoiceRedraftPageVO invoiceRedraftPageVO = this.buildInvoiceRedraft(saleInvDTO, saleInvdDtlDO);
        return invoiceRedraftPageVO;
    }

    private InvoiceRedraftPageVO buildInvoiceRedraft(SaleInvDTO saleInvDTO, SaleInvdDtlDO saleInvdDtlDO) {
        InvoiceRedraftPageVO invoiceRedraftPageVO = new InvoiceRedraftPageVO();
        invoiceRedraftPageVO.setInvoiceNo(saleInvdDtlDO.getInvNo());
        invoiceRedraftPageVO.setSerialNo(saleInvdDtlDO.getFlowNo());
        invoiceRedraftPageVO.setInvoiceAmt(saleInvdDtlDO.getTotalAmt());
        invoiceRedraftPageVO.setInvoiceDate(saleInvdDtlDO.getInvDate());
        invoiceRedraftPageVO.setInvoiceType(saleInvDTO.getInvType());
        return invoiceRedraftPageVO;
    }

    private SaleInvDO querySaleInvDOById(Long id) {
        List<SaleInvDO> saleInvDOList = this.saleInvRepo.findAllById(id);
        Assert.isTrue((saleInvDOList.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636eid\u4e0d\u5230\u6570\u636e/\u67e5\u5230\u591a\u6761\u6570\u636e", (Object[])new Object[0]);
        SaleInvDO saleInvDO = saleInvDOList.get(0);
        return saleInvDO;
    }

    private SaleInvdDtlDO querySaleInvdDtlDOById(Long id) {
        List<SaleInvdDtlDO> saleInvdDtlDOList = this.saleInvdDtlRepo.findAllById(id);
        Assert.isTrue((saleInvdDtlDOList.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636eid\u4e0d\u5230\u6570\u636e/\u67e5\u5230\u591a\u6761\u6570\u636e", (Object[])new Object[0]);
        return saleInvdDtlDOList.get(0);
    }

    private SaleInvdDtlDO querySaleInvdDtlDOByInvoiceNo(String invoiceNo) {
        List<SaleInvdDtlDO> saleInvdDtlDOList = this.saleInvdDtlRepo.findAllByInvNo(invoiceNo);
        Assert.isTrue((saleInvdDtlDOList.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636eid\u4e0d\u5230\u6570\u636e/\u67e5\u5230\u591a\u6761\u6570\u636e", (Object[])new Object[0]);
        return saleInvdDtlDOList.get(0);
    }

    @Override
    @Transactional
    public void update(SaleInvdParam param) {
        Assert.notNull((Object)param.getInvoiceNo(), (String)"\u53d1\u7968\u53f7\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getInvoiceRedraftState(), (String)"\u6362\u5f00\u5ba1\u6838\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        SaleInvdDtlDO saleInvdDtlDO = this.querySaleInvdDtlDOByInvoiceNo(param.getInvoiceNo());
        saleInvdDtlDO.setInvoiceRedraftState(param.getInvoiceRedraftState());
    }

    @Override
    public SaleInvDetailAppVO appGet(Long id) {
        return this.saleInvdDtlRepoProc.appGet(id);
    }

    public SaleInvdDomainServiceImpl(SaleInvdDtlRepoProc saleInvdDtlRepoProc, SaleInvdDtlRepo saleInvdDtlRepo, InvoiceRuleConfigDomainService invoiceRuleConfigDomainService, InvoiceRedraftRepo invoiceRedraftRepo, InvoiceRedraftRepoProc invoiceRedraftRepoProc, SaleInvRepo saleInvRepo, InvoiceAwaitService invoiceAwaitService, InvoiceService invoiceService) {
        this.saleInvdDtlRepoProc = saleInvdDtlRepoProc;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.invoiceRuleConfigDomainService = invoiceRuleConfigDomainService;
        this.invoiceRedraftRepo = invoiceRedraftRepo;
        this.invoiceRedraftRepoProc = invoiceRedraftRepoProc;
        this.saleInvRepo = saleInvRepo;
        this.invoiceAwaitService = invoiceAwaitService;
        this.invoiceService = invoiceService;
    }
}

