package com.elitesland.fin.application.facade.vo.creditaccountflow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : gyj
 * @date : 2023-2-24
 */
@ApiModel(value = "信用账户流水", description = "信用账户流水")
@Data
public class CreditAccountFlowVO extends CustomFieldBaseModelVo {

    @ApiModelProperty("授信组织/公司编码")
    private String ouCode;

    @ApiModelProperty("授信组织/公司名称")
    private String ouName;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("对象名称")
    private String objectName;

    @ApiModelProperty("对象类型")
    @SysCode(sys = "yst-fin", mod = "OBJECT_TYPE")
    private String objectType;
    private String objectTypeName;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("产品线")
    private String productLine;

    @ApiModelProperty("业务员")
    private String saleUser;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易类型")
    @SysCode(sys = "yst-fin", mod = "CREDIT_IO_TYPE")
    private String transactionType;
    private String transactionTypeName;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ApiModelProperty("信用账户名称")
    private String creditAccountName;

    @ApiModelProperty("信用账户类型")
    @SysCode(sys = "yst-fin", mod = "CREDIT_ACCOUNT_TYPE")
    private String creditAccountType;
    private String creditAccountTypeName;


    @ApiModelProperty("信用账户规则编码")
    private String creditAccountRuleCode;

    @ApiModelProperty("信用账户规则名称")
    private String creditAccountRuleName;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDoc;
    private String sourceDocName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据ID")
    private Long sourceId;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("优先级")
    private Integer priorityNo;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("可用额度")
    private BigDecimal creditAccountAvailableLimit;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_FLOW_BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("归属公司")
    private String touCode;
    @ApiModelProperty("归属公司名称")
    private String touCodeName;

    @ApiModelProperty("关联流水号")
    private String relateFlowNo;

    @ApiModelProperty("同步状态")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_FLOW_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("同步异常日志")
    private String syncLog;

    @ApiModelProperty("出账方账号")
    private String fromAccountNo;

    @ApiModelProperty("入账方账号")
    private String toAccountNo;

    @ApiModelProperty("出账公司")
    private String fromOuCode;
    @ApiModelProperty("出账公司名称")
    private String fromOuName;

    @ApiModelProperty("入账公司")
    private String toOuCode;
    @ApiModelProperty("入账公司名称")
    private String toOuName;

    @ApiModelProperty("来源根单据类型")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String rootDoc;
    private String rootDocName;

    @ApiModelProperty("来源根单号")
    private String rootDocNo;

    @ApiModelProperty("操作类型")
    @SysCode(sys = "yst-fin", mod = "FLOW_OPT_TYPE")
    private String optType;
    private String optTypeName;
}
