package com.elitesland.fin.application.facade.param.expense;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDtlDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@ApiModel(description = "账户规则传输类")
@Data
public class ExpRuleConfigSaveParam extends BaseModelParam implements Serializable {

    private static final long serialVersionUID = -2808417099440678762L;

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("费用类型编码")
    private String expTypeCode;

    @ApiModelProperty("是否启用")
    private Boolean enableFlag;

    @ApiModelProperty("计算方式 1固定金额/2固定比例")
    private String calculateType;

    @ApiModelProperty("计算比例")
    private BigDecimal calculatePercent;

    @ApiModelProperty("计算比例金额来源")
    private String calculatePercentSrc;

    @ApiModelProperty("单位金额")
    private BigDecimal uomAmt;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty(value = "台账自动审核 1-是 0-否")
    private boolean automaticReview;

    @ApiModelProperty("生效日期")
    private LocalDate validDate;

    public List<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList;

}
