package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/19
 */
@Data
@ApiModel("开票申请")
public class InvoiceApplySaveParam implements Serializable {

    @ApiModelProperty("明细表ID")
    private Long id;

    @ApiModelProperty("付款记录表头ID")
    private Long masId;

    @ApiModelProperty("明细行号")
    private Integer lineNo;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("税收分类编码")
    private String taxType;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String serviceName;

    @ApiModelProperty("规格")
    private String itemSpec;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal originAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal tax;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("待开发票单号")
    private String docNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("待开发票状态")
    private String invoiceAwaitStatus;

    @ApiModelProperty("来源单据")
    private String optDocType;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("发票文件编码")
    private String invoiceFileCode;

    @ApiModelProperty("开票申请单号")
    private String invoiceApplyNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("来源单据名称")
    private String optDocCls;

    @ApiModelProperty("来源单据ID")
    private Long optDocId;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-fin", mod = "PAYMENT_STATUS")
    private String paymentStatus;
    private String paymentStatusName;

    /**
     * 开户银行
     */
    @ApiModelProperty(name = "开户银行")
    private String invBankNo;
    /**
     * 银行账号
     */
    @ApiModelProperty(name = "银行账号")
    private String bankAccount;
    @ApiModelProperty(name = "收费项目名称")
    private String itemCodeName;

    @ApiModelProperty(name = "实收金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty(name = "税额")
    private BigDecimal taxAmt;

    /**
     * 日期
     */
    @ApiModelProperty(name = "通知日期")
    private LocalDate noticeDate;

    @ApiModelProperty(name = "付款日期")
    private LocalDate paymentDate;

    @ApiModelProperty(name = "通知id")
    private Long noticeId;

    /**
     * 通知内容
     */
    @ApiModelProperty(name = "通知内容")
    private String noticeContent;

    @ApiModelProperty(name = "联行号")
    private String uniBankNo;

    @ApiModelProperty(name = "付款凭证编码")
    private String voucherFileCode;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("来源单据类型")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDocType;
    private String sourceDocTypeName;

    @ApiModelProperty("来源单据ID")
    private Long sourceDocId;

    @ApiModelProperty("来源单据单号")
    private String sourceDocNo;

    @ApiModelProperty("是否参与开票")
    @SysCode(sys = "yst-fin", mod = "IS_BILLING")
    private String isToBilling;

    @ApiModelProperty("是否参与开票中文")
    private String isToBillingName;

    @ApiModelProperty("开票详情")
    private String invoiceInfo;

    @ApiModelProperty("付款银行")
    private String payBank;
    @ApiModelProperty("付款账户")
    private String payAccount;
    @ApiModelProperty("付款类型")
    @SysCode(sys = "yst-fin",mod = "PAY_METHOD")
    private String payType;
    private String payTypeName;

    @ApiModelProperty("来源系统单号")
    private String sourceSysNo;

    @ApiModelProperty("开票申请单号")
    private String applyNo;

    @ApiModelProperty("发票登记单号")
    private String invRegNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额(开票申请金额)")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("销售方发票抬头")
    private String saleInvTitle;

    @ApiModelProperty("销售税号")
    private String saleTaxNo;

    @ApiModelProperty("销售方电话")
    private String saleTel;

    @ApiModelProperty("销售详细地址")
    private String saleAdd;

    @ApiModelProperty("销售方开户行")
    private String saleBank;

    @ApiModelProperty("销售方银行账号")
    private String saleBankAcc;

    @ApiModelProperty("销售方备注")
    private String saleRemark;

    @ApiModelProperty("供应商ID")
    private Long saleId;

    @ApiModelProperty("供应商名称")
    private String saleName;

    @ApiModelProperty("供应商编码")
    private String saleCode;

    @ApiModelProperty("客户方发票抬头")
    private String custInvTitle;

    @ApiModelProperty("纳税人识别号")
    private String custTaxNo;

    @ApiModelProperty("客户地址")
    private String custAdd;

    @ApiModelProperty("客户电话")
    private String custTel;

    @ApiModelProperty("客户银行")
    private String custBank;

    @ApiModelProperty("客户银行账号")
    private String custBankAcc;

    @ApiModelProperty("客户备注")
    private String custRemark;

    @ApiModelProperty("开票人")
    private String invUser;

    @ApiModelProperty("收款人")
    private String recUser;

    @ApiModelProperty("复核人")
    private String revUser;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("推送方式")
    private String pushMethod;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("信息表编号")
    private String infoNo;

    @ApiModelProperty("开票抬头")
    private String invTitle;

    @ApiModelProperty("快递编号")
    private String expressNo;

    @ApiModelProperty("开票状态")
    private String invState;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("相同商品合并开票：1是；0否；")
    private String invMerge;

    @ApiModelProperty(value = "是否自动开票 1-是 0-否")
    private Integer autoInvoice;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("开票明细")
    private List<InvoiceDetailSaveParam> details;

    @ApiModelProperty(value = "开票申请是否自动审核 ture-是 false-否")
    private Boolean autoReview;

    @ApiModelProperty(value = "待开发票申请表ID")
    private Long invoiceId;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;

    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty("开票客户名称")
    private String invCustName;

    @ApiModelProperty("开票客户编码")
    private String invCustCode;

    @ApiModelProperty("开票客户ID")
    private Long invCustId;

    @ApiModelProperty("开票抬头类型")
    private String invTitleType;
    @ApiModelProperty("开票邮箱")
    private String invEmail;
    @ApiModelProperty("开票联系人")
    private String invPicName;
    @ApiModelProperty("开票联系人电话")
    private String invPicPhone;
    @ApiModelProperty("对账申请时间")
    private LocalDateTime recApplyTime;
}
