package com.elitesland.fin.application.facade.vo.aporder;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.common.LocalDateTimeConverter;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.aporder
 * @date 2022/3/16 15:10
 */
@Data
public class ApOrderVO extends CustomFieldBaseModelVo implements Serializable, WriteoffVO {

    private static final long serialVersionUID = 8817977072357947605L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ExcelIgnore
    private Long id;

    @ExcelProperty("来源系统单号")
    @ApiModelProperty(value = "来源系统单号")
    private String sourceNo;

    @ExcelProperty("应付单编号")
    @ApiModelProperty(value = "应付单编号")
    private String apOrderNo;

    @ApiModelProperty(value = "公司编码")
    @ExcelIgnore
    private String ouCode;

    @ApiModelProperty(value = "公司ID")
    @ExcelIgnore
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ExcelProperty("公司")
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "来源单据")
    @SysCode(sys = "yst-fin", mod = "AP_DOC_CLS")
    private String createMode;
    private String createModeName;

    @ApiModelProperty(value = "应付单类型定义ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @ExcelIgnore
    private Long apTypeId;

    @ExcelProperty("应付单类型")
    @ApiModelProperty(value = "应付单类型名称")
    private String apTypeName;

    @ApiModelProperty(value = "应付单类型代码")
    @ExcelIgnore
    private String apTypeCode;

    @ApiModelProperty(value = "单据状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ExcelProperty(value = "业务日期", converter = LocalDateTimeConverter.class)
    @ApiModelProperty(value = "业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty(value = "含税总金额")
    @ExcelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ExcelProperty("税额")
    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ExcelProperty("税额(本位币)")
    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ExcelProperty("含税总金额(本位币)")
    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ExcelProperty("不含税总金额")
    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    @ExcelIgnore
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "币种编码")
    @ExcelIgnore
    private String currCode;

    @ExcelProperty("币种")
    @ApiModelProperty(value = "币种")
    private String currName;

    @ApiModelProperty(value = "审核人ID")
    @ExcelIgnore
    @JsonSerialize(using = ToStringSerializer.class)
    private Long auditUserId;

    @ExcelProperty("审核人")
    @ApiModelProperty(value = "审核人")
    private String auditUser;

    @ApiModelProperty(value = "审核时间")
    @ExcelIgnore
    private LocalDateTime auditDate;

    @ApiModelProperty(value = "经办人ID")
    @ExcelIgnore
    @JsonSerialize(using = ToStringSerializer.class)
    private Long operUserId;

    @ExcelProperty("经办人")
    @ApiModelProperty(value = "经办人")
    private String operator;

    @ApiModelProperty(value = "是否期初")
    @ExcelIgnore
    private Boolean initFlag;

    @ApiModelProperty(value = "供应商ID")
    @ExcelIgnore
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    @ExcelIgnore
    private String suppCode;

    @ExcelProperty("供应商名称")
    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ExcelProperty("创建人")
    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "审核拒绝意见")
    @ExcelIgnore
    private String auditRejection;

    @ExcelProperty("备注")
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "是否含税")
    @ExcelIgnore
    private Boolean taxFlag;

    @ApiModelProperty(value = "汇率")
    @ExcelIgnore
    private BigDecimal exchangeRate;


    @ApiModelProperty(value = "部门ID")
    @ExcelIgnore
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "部门编码")
    @ExcelIgnore
    private String buCode;

    @ApiModelProperty(value = "部门名称")
    @ExcelIgnore
    private String buName;

    @ApiModelProperty(value = "付款条件")
    @ExcelIgnore
    private String payMentName;
    private String payMentId;
    private String payMentCode;

    @ApiModelProperty(value = "创建日期")
    @ExcelIgnore
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人")
    @ExcelIgnore
    private String updater;

    @ApiModelProperty("修改时间")
    @ExcelIgnore
    private LocalDateTime modifyTime;

    @ExcelProperty("总数量")
    @ApiModelProperty(value = "总数量，汇总明细单行数")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long totalCount;

    @ApiModelProperty(value = "传输状态")
    @ExcelIgnore
    private String tranState;

    @ExcelProperty("入账日期")
    @ApiModelProperty(value = "入账日期")
    private String entryDate;

    @ApiModelProperty("应付单明细信息")
    @ExcelIgnore
    private List<ApOrderDtlVO> apOrderDtlVOList;

    @ApiModelProperty("应付单汇总信息")
    @ExcelIgnore
    private List<ApOrderDtlGroupVO> apOrderDtlGroupVOList;

    @ApiModelProperty("本位币编码")
    @ExcelIgnore
    private String localCurrCode;

    @ExcelIgnore
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("本位币名称")
    @ExcelIgnore
    private String localCurrName;

    @ApiModelProperty("核销状态")
    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    private String verState;
    private String verStateName;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;
    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-purc", mod = "IO_TYPE")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("协议名称")
    private String protocolName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    @ApiModelProperty("关联公司名称")
    private String relevanceOuName;

}
