package com.elitesland.fin.application.facade.vo.recorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:16
 */
@Data
public class RecOrderDtlVO implements Serializable {

    private static final long serialVersionUID = -8554671614425038666L;

    @ApiModelProperty("付款银行账号")
    private String es16;

    @ApiModelProperty("付款银行账户")
    private String es17;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("收款方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String recType;
    private String recTypeName;

    @ApiModelProperty("收款类型")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_TYPE")
    private String recKind;
    private String recKindName;

    @ApiModelProperty("收款银行名称")
    private String recBank;

    @ApiModelProperty("收款银行账户")
    private String recAccount;

    @ApiModelProperty("收款流水")
    private String recFlow;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-fin", mod = "EXPENSES_TYPE")
    private String expensesType;
    private String expensesTypeName;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;
    @ApiModelProperty("未核销金额")
    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

    @ApiModelProperty("已核销金额")
    @Column(name = "ver_amt", columnDefinition = "decimal(16,4)  comment '已核销金额'")
    private BigDecimal verAmt;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmTing;



    @ApiModelProperty(value = "收款单ID")
    private Long recId;

    @ApiModelProperty(value = "第三方收款单号")
    private String outRecDocNo;

    @ApiModelProperty(value = "应收单号")
    private String recDocNo;

    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    @ApiModelProperty(value = "外部收款单明细ID")
    private String outRecDId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "收款业务类型")
    private String recBuType;

    @ApiModelProperty(value = "收款性质")
    private String recNat;

    @ApiModelProperty(value = "未核销金额")
    private BigDecimal notVerAmt;
}
