package com.elitesland.fin.repo.invoice;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.entity.invoice.QInvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.QInvoiceAwaitDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class InvoiceAwaitRepoProc {
    private static final QInvoiceAwaitDO qdo = QInvoiceAwaitDO.invoiceAwaitDO;

    private static final QInvoiceAwaitDDO D_QDO = QInvoiceAwaitDDO.invoiceAwaitDDO;
    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<InvoiceAwaitDTO> queryInvoiceAwait(InvoiceAwaitQueryParam param) {

        List<Long> ids = getIds(param);
        if (CollectionUtil.isEmpty(ids)) {
            return PagingVO.<InvoiceAwaitDTO>builder()
                    .total(0)
                    .records(new ArrayList<>())
                    .build();
        }
        JPAQuery<InvoiceAwaitDTO> query = select(InvoiceAwaitDTO.class).where(qdo.id.in(ids));
        //数据权限
        BusinessSecurityUtil.where(query, InvoiceAwaitDO.class);
        param.setPaging(query);
        param.fillOrders(query, qdo);
        return PagingVO.<InvoiceAwaitDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Long> getIds(InvoiceAwaitQueryParam param) {

        List<Predicate> where = where(param);
        if (StrUtil.isNotBlank(param.getCustName())) {
            String likeStr = "%" + param.getCustName() + "%";
            where.add(D_QDO.custName.like(likeStr));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(param.getConditions(), InvoiceAwaitDO.class);
        if(customFieldPredicate!=null){
            where.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
       //增加扩展字段查询条件end
        List<Long> ids = jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .leftJoin(D_QDO).on(D_QDO.masId.eq(qdo.id))
                .where(ExpressionUtils.allOf(where)).fetch();
        if(CollectionUtils.isNotEmpty(param.getIds())) {
            ids.addAll(param.getIds());
        }
        ids = ids.stream().distinct().collect(Collectors.toList());
        return ids;
    }

    /**
     * 拼装查询条件
     *
     * @param param 查询参数
     * @return 条件
     */
    private List<Predicate> where(InvoiceAwaitQueryParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(param.getInvoiceAwaitStatus())) {
            predicates.add(qdo.invoiceAwaitStatus.eq(param.getInvoiceAwaitStatus()));
        }
        if(CollectionUtils.isNotEmpty(param.getInvoiceAwaitStatusList())){
            predicates.add(qdo.invoiceAwaitStatus.in(param.getInvoiceAwaitStatusList()));
        }
        if (StrUtil.isNotBlank(param.getDocNo())) {
            String likeStr = "%" + param.getDocNo() + "%";
            predicates.add(qdo.docNo.like(likeStr));
        }
        if(CollectionUtils.isNotEmpty(param.getDocNoList())){
            predicates.add(qdo.docNo.in(param.getDocNoList()));
        }
        if (StrUtil.isNotBlank(param.getOptDocNo())) {
            String likeStr = "%" + param.getOptDocNo() + "%";
            predicates.add(qdo.optDocNo.like(likeStr));
        }

        if (StrUtil.isNotBlank(param.getOuCode())) {
            predicates.add(qdo.ouCode.eq(param.getOuCode()));
        }
        /*if(CollectionUtils.isNotEmpty(param.getOuCodeList())){
            predicates.add(qdo.ouCode.in(param.getOuCodeList()));
        }*/
        if (StrUtil.isNotBlank(param.getMainCustCode())) {
            predicates.add(qdo.mainCustCode.eq(param.getMainCustCode()));
        }
        if(CollectionUtils.isNotEmpty(param.getMainCustCodeList())){
            predicates.add(qdo.mainCustCode.in(param.getMainCustCodeList()));
        }
        if (StrUtil.isNotBlank(param.getMainCustName())) {
            predicates.add(qdo.mainCustName.like("%" + param.getMainCustName() + "%"));
        }
        if(CollectionUtils.isNotEmpty(param.getMainCustNameList())){
            predicates.add(qdo.mainCustName.in(param.getMainCustNameList()));
        }
        if (StrUtil.isNotBlank(param.getCustCode())) {
            predicates.add(qdo.custCode.eq(param.getCustCode()));
        }
        if(CollectionUtils.isNotEmpty(param.getCustCodeList())){
            predicates.add(qdo.custCode.in(param.getCustCodeList()));
        }



        if(CollectionUtils.isNotEmpty(param.getCustNameList())){
            predicates.add(D_QDO.custName.in(param.getCustNameList()));
        }
        return predicates;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qdo.id,
                qdo.docNo,
                qdo.ouId,
                qdo.ouCode,
                qdo.ouName,
                qdo.custId,
                qdo.custName,
                qdo.custCode,
                qdo.amt,
                qdo.invoiceAwaitStatus,
                qdo.optDocCls,
                qdo.optDocType,
                qdo.optDocStatus,
                qdo.optDocId,
                qdo.optDocNo,
                qdo.invoiceFileCode,
                qdo.invoiceApplyNo,
                qdo.remark,
                qdo.invoiceType,
                qdo.mainCustCode,
                qdo.mainCustId,
                qdo.mainCustName,
                qdo.confirmTime,
                qdo.pkGroup,
                qdo.settlementType,
                qdo.openInvType,
                qdo.currRate,
                qdo.currCode,
                qdo.extensionInfo,
                qdo.invType,
                qdo.invAddress,
                qdo.invTitle,
                qdo.invTitleType,
                qdo.invTel,
                qdo.invEmail,
                qdo.invPicName,
                qdo.invPicPhone,
                qdo.invBankName,
                qdo.invBankAcc,
                qdo.taxerNo,
                qdo.recApplyTime,
                qdo.storeCode

        )).from(qdo);
    }

    @SysCodeProc
    public List<InvoiceAwaitRespVO> findByIds(List<Long> ids) {
//        predicates.add(D_QDO.isToBilling.eq("0"));
        var jpaQuery = jpaQueryFactory.select(detailList)
                .from(qdo)
                .leftJoin(D_QDO).on(qdo.id.eq(D_QDO.masId))
                .where(qdo.id.in(ids));
        return jpaQuery.fetch();
    }
    private <T> JPAQuery<T> selectDtl(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qdo.id.as("masId"),
                qdo.docNo,
                qdo.ouId,
                qdo.ouCode,
                qdo.ouName,
                qdo.custId,
                qdo.custName,
                qdo.custCode,
                qdo.amt.as("totalAmt"),
                qdo.invoiceAwaitStatus,
                qdo.optDocType,
                qdo.optDocNo,
                qdo.optDocCls,
                qdo.optDocId,
                qdo.optDocStatus,
                qdo.invoiceFileCode,
                qdo.invoiceApplyNo,
                qdo.remark,
                qdo.invoiceType,
                qdo.mainCustCode,
                qdo.mainCustId,
                qdo.mainCustName,
                qdo.settlementType,
                qdo.pkGroup,
                qdo.openInvType,
                qdo.currRate,
                qdo.extensionInfo,
                qdo.invType,
                qdo.invAddress,
                qdo.invTitle,
                qdo.invTitleType,
                qdo.invTel,
                qdo.invEmail,
                qdo.invPicName,
                qdo.invPicPhone,
                qdo.invBankName,
                qdo.invBankAcc,
                qdo.taxerNo,
                qdo.recApplyTime,
                qdo.storeCode,
                D_QDO.id,
                D_QDO.lineNo,
                D_QDO.itemCode,
                D_QDO.itemName,
                D_QDO.itemId,
                D_QDO.taxType,
                D_QDO.serviceName,
                D_QDO.itemSpec,
                D_QDO.uom,
                D_QDO.qty,
                D_QDO.originAmt,
                D_QDO.amt,
                D_QDO.taxRate,
                D_QDO.tax,
                D_QDO.netAmt,
                D_QDO.agentName,
                D_QDO.recvContactName,
                D_QDO.recvContactTel,
                D_QDO.recvDetailaddr,
                D_QDO.soSource,
                D_QDO.giftsFlag,
                D_QDO.flDeductionAmt,
                D_QDO.invDiscount,
                D_QDO.invDiscountAmt,
                D_QDO.discountAmt,
                D_QDO.invAmt,
                D_QDO.invTaxAmt,
                D_QDO.invNetAmt,
                D_QDO.custCode.as("dtlCustCode"),
                D_QDO.custName.as("dtlCustName"),
                D_QDO.custId.as("dtlCustId"),
                D_QDO.docNo.as("relateDocNo"),
                D_QDO.relateDocDid,
                D_QDO.rootDocTime
        ));
    }
    private final QBean<InvoiceAwaitRespVO> detailList = Projections.bean(
            InvoiceAwaitRespVO.class,
            qdo.id.as("masId"),
            qdo.docNo,
            qdo.ouId,
            qdo.ouCode,
            qdo.ouName,
            qdo.custId,
            qdo.custName,
            qdo.custCode,
            qdo.amt.as("totalAmt"),
            qdo.invoiceAwaitStatus,
            qdo.optDocType,
            qdo.optDocNo,
            qdo.optDocCls,
            qdo.optDocId,
            qdo.optDocStatus,
            qdo.invoiceFileCode,
            qdo.invoiceApplyNo,
            qdo.remark,
            qdo.invoiceType,
            qdo.mainCustCode,
            qdo.mainCustId,
            qdo.mainCustName,
            qdo.settlementType,
            qdo.pkGroup,
            qdo.openInvType,
            qdo.currRate,
            qdo.extensionInfo,
            qdo.invType,
            qdo.invAddress,
            qdo.invTitle,
            qdo.invTitleType,
            qdo.invTel,
            qdo.invEmail,
            qdo.invPicName,
            qdo.invPicPhone,
            qdo.invBankName,
            qdo.invBankAcc,
            qdo.taxerNo,
            qdo.recApplyTime,
            qdo.storeCode,
            D_QDO.id,
            D_QDO.lineNo,
            D_QDO.itemCode,
            D_QDO.itemName,
            D_QDO.itemId,
            D_QDO.taxType,
            D_QDO.serviceName,
            D_QDO.itemSpec,
            D_QDO.uom,
            D_QDO.qty,
            D_QDO.originAmt,
            D_QDO.amt,
            D_QDO.taxRate,
            D_QDO.tax,
            D_QDO.netAmt,
            D_QDO.agentName,
            D_QDO.recvContactName,
            D_QDO.recvContactTel,
            D_QDO.recvDetailaddr,
            D_QDO.soSource,
            D_QDO.giftsFlag,
            D_QDO.flDeductionAmt,
            D_QDO.invDiscount,
            D_QDO.invDiscountAmt,
            D_QDO.discountAmt,
            D_QDO.invAmt,
            D_QDO.invTaxAmt,
            D_QDO.invNetAmt,
            D_QDO.custCode.as("dtlCustCode"),
            D_QDO.custName.as("dtlCustName"),
            D_QDO.custId.as("dtlCustId"),
            D_QDO.docNo.as("relateDocNo"),
            D_QDO.relateDocDid
    );

    private Predicate where(InvoiceApplyParam param) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andIn(CollectionUtil.isNotEmpty(param.getIds()), qdo.id, param.getIds())
                .build();
    }

    public void updateApplyNoByIds(Set<Long> sourceDocId, String applyNo, String invoiceStatus) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qdo)
                .set(qdo.invoiceApplyNo, applyNo)
                .set(qdo.invoiceAwaitStatus, invoiceStatus)
                .where(qdo.id.in(sourceDocId));
        jpaUpdateClause.execute();
    }

    public List<InvoiceAwaitDTO> findByApplyNo(String applyNo) {

        JPAQuery<InvoiceAwaitDTO> query = select(InvoiceAwaitDTO.class).where(qdo.invoiceApplyNo.eq(applyNo));
        return query.fetch();
    }

    public void updateInvState(SaleInvStatusParam param) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qdo)
                .set(qdo.invoiceAwaitStatus, param.getInvState());

        if (StrUtil.equals(param.getInvState(), UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode())) {
            jpaUpdateClause.setNull(qdo.invoiceApplyNo).setNull(qdo.invoiceFileCode);
        }

        jpaUpdateClause.where(qdo.invoiceApplyNo.eq(param.getApplyNo()));
        jpaUpdateClause.execute();
    }


    public void updateDeleteFlagByOptDocNoBatch(Integer deleteFlag, List<String> optDocNos) {
        jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, deleteFlag)
                .where(qdo.optDocNo.in(optDocNos))
                .execute();
    }

    public void updateDeleteFlagByOptDocIdBatch(Integer deleteFlag, List<Long> optDocIds) {
        jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, deleteFlag)
                .where(qdo.optDocId.in(optDocIds))
                .execute();
    }

    public void updateDeleteFlagByIdBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, deleteFlag)
                .where(qdo.id.in(ids))
                .execute();
    }

    public List<Long> selectInvoiceAwaitIdByOptDoc(List<String> optDocNos,List<Long> optDocIds) {
        List<Predicate> predicates = new ArrayList<>();

        if (CollectionUtil.isNotEmpty(optDocNos)) {
            predicates.add(qdo.optDocNo.in(optDocNos));
        }
        if (CollectionUtil.isNotEmpty(optDocIds)) {
            predicates.add(qdo.optDocId.in(optDocIds));
        }
        return jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .where(ExpressionUtils.allOf(predicates)).fetch();
    }



}
