package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalLogParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalLogVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalVO;
import com.elitesland.fin.application.service.accountingengine.FinJournalLogService;
import com.elitesland.fin.application.service.accountingengine.FinJournalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/journal/log")
@RequiredArgsConstructor
@Api(value = "凭证日志", tags = {"凭证日志"})
public class FinJournalLogController {

    private final FinJournalLogService finJournalLogService;

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinJournalLogVO>> page(@RequestBody FinJournalLogParam finJournalLogParam) {
        return ApiResult.ok(finJournalLogService.page(finJournalLogParam));
    }




}
